/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.tz;

import org.teavm.classlib.impl.Base46;
import org.teavm.classlib.impl.CharFlow;
import org.teavm.classlib.impl.tz.StorableDateTimeZone;

public final class FixedDateTimeZone
extends StorableDateTimeZone {
    private final int iWallOffset;
    private final int iStandardOffset;

    public FixedDateTimeZone(String id, int wallOffset, int standardOffset) {
        super(id);
        this.iWallOffset = wallOffset;
        this.iStandardOffset = standardOffset;
    }

    @Override
    public int getOffset(long instant) {
        return this.iWallOffset;
    }

    @Override
    public int getStandardOffset(long instant) {
        return this.iStandardOffset;
    }

    @Override
    public int getOffsetFromLocal(long instantLocal) {
        return this.iWallOffset;
    }

    @Override
    public boolean isFixed() {
        return true;
    }

    @Override
    public long nextTransition(long instant) {
        return instant;
    }

    @Override
    public long previousTransition(long instant) {
        return instant;
    }

    @Override
    public void write(StringBuilder sb) {
        Base46.encodeUnsigned(sb, 1);
        FixedDateTimeZone.writeTime(sb, this.iWallOffset);
        FixedDateTimeZone.writeTime(sb, this.iStandardOffset);
    }

    public static FixedDateTimeZone readZone(String id, CharFlow flow) {
        int wallOffset = (int)FixedDateTimeZone.readTime(flow);
        int standardOffset = (int)FixedDateTimeZone.readTime(flow);
        return new FixedDateTimeZone(id, wallOffset, standardOffset);
    }
}

