/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.charset;

import org.teavm.classlib.impl.charset.ByteBuffer;
import org.teavm.classlib.impl.charset.CharBuffer;
import org.teavm.classlib.impl.charset.Charset;
import org.teavm.classlib.impl.charset.UTF16Helper;

public class UTF8Charset
extends Charset {
    @Override
    public void encode(CharBuffer source, ByteBuffer dest) {
        while (!source.end() && dest.available() >= 4) {
            char ch = source.get();
            if (ch < '\u0080') {
                dest.put((byte)ch);
                continue;
            }
            if (ch < '\u0400') {
                dest.put((byte)(0xC0 | ch >> 6));
                dest.put((byte)(0x80 | ch & 0x3F));
                continue;
            }
            if (!UTF16Helper.isSurrogate(ch)) {
                dest.put((byte)(0xE0 | ch >> 12));
                dest.put((byte)(0x80 | ch >> 6 & 0x3F));
                dest.put((byte)(0x80 | ch & 0x3F));
                continue;
            }
            if (UTF16Helper.isHighSurrogate(ch)) {
                char low = source.get();
                if (!UTF16Helper.isLowSurrogate(low)) {
                    source.back(1);
                    dest.put((byte)63);
                    continue;
                }
                int codePoint = UTF16Helper.buildCodePoint(ch, low);
                dest.put((byte)(0xF0 | codePoint >> 18));
                dest.put((byte)(0x80 | codePoint >> 12 & 0x3F));
                dest.put((byte)(0x80 | codePoint >> 6 & 0x3F));
                dest.put((byte)(0x80 | codePoint & 0x3F));
                continue;
            }
            dest.put((byte)63);
        }
    }

    @Override
    public void decode(ByteBuffer source, CharBuffer dest) {
        while (!source.end() && dest.available() >= 2) {
            byte b3;
            byte b2;
            int b = source.get() & 0xFF;
            if ((b & 0x80) == 0) {
                dest.put((char)b);
                continue;
            }
            if ((b & 0xE0) == 192) {
                if (source.end()) {
                    dest.put((char)b);
                    return;
                }
                dest.put((char)((b & 0x1F) << 6 | source.get() & 0x3F));
                continue;
            }
            if ((b & 0xF0) == 224) {
                if (source.available() < 2) {
                    source.skip(source.available());
                    dest.put((char)b);
                    return;
                }
                b2 = source.get();
                char c = (char)((b & 0xF) << 12 | (b2 & 0x3F) << 6 | (b3 = source.get()) & 0x3F);
                dest.put(!UTF16Helper.isHighSurrogate(c) ? c : (char)'?');
                continue;
            }
            if ((b & 0xF8) != 240) continue;
            if (source.available() < 3) {
                source.skip(source.available());
                dest.put((char)b);
                return;
            }
            b2 = source.get();
            b3 = source.get();
            byte b4 = source.get();
            int code = (b & 7) << 18 | (b2 & 0x3F) << 12 | (b3 & 0x3F) << 6 | b4 & 0x3F;
            dest.put(UTF16Helper.highSurrogate(code));
            dest.put(UTF16Helper.lowSurrogate(code));
        }
    }
}

