/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import org.teavm.classlib.java.io.TSerializable;
import org.teavm.classlib.java.lang.TCloneNotSupportedException;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.TUnsupportedOperationException;
import org.teavm.classlib.java.util.TAbstractCollection;
import org.teavm.classlib.java.util.TAbstractSet;
import org.teavm.classlib.java.util.TCollection;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TMap;
import org.teavm.classlib.java.util.TObjects;
import org.teavm.classlib.java.util.TSet;

public abstract class TAbstractMap<K, V>
extends TObject
implements TMap<K, V> {
    TSet<K> cachedKeySet;
    TCollection<V> cachedValues;

    protected TAbstractMap() {
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsValue(Object value) {
        TIterator iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            Object knownValue = ((TMap.Entry)iter.next()).getValue();
            if (!TObjects.equals(value, knownValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        TIterator iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            Object knownKey = ((TMap.Entry)iter.next()).getKey();
            if (!TObjects.equals(key, knownKey)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        TIterator iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            TMap.Entry entry = (TMap.Entry)iter.next();
            if (!TObjects.equals(key, entry.getKey())) continue;
            return (V)entry.getValue();
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        throw new TUnsupportedOperationException();
    }

    @Override
    public void putAll(TMap<? extends K, ? extends V> m) {
        TIterator iter = m.entrySet().iterator();
        while (iter.hasNext()) {
            TMap.Entry entry = (TMap.Entry)iter.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        TIterator iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            TMap.Entry entry = (TMap.Entry)iter.next();
            if (!TObjects.equals(key, entry.getKey())) continue;
            iter.remove();
            return (V)entry.getValue();
        }
        return null;
    }

    @Override
    public abstract TSet<TMap.Entry<K, V>> entrySet();

    @Override
    public void clear() {
        this.entrySet().clear();
    }

    @Override
    public TSet<K> keySet() {
        if (this.cachedKeySet == null) {
            this.cachedKeySet = new KeySet();
        }
        return this.cachedKeySet;
    }

    @Override
    public TCollection<V> values() {
        if (this.cachedValues == null) {
            this.cachedValues = new Values();
        }
        return this.cachedValues;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TMap)) {
            return false;
        }
        TMap other = (TMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        TIterator iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            TMap.Entry entry = (TMap.Entry)iter.next();
            if (!other.containsKey(entry.getKey())) {
                return false;
            }
            if (TObjects.equals(entry.getValue(), other.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        TIterator iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            TMap.Entry entry = (TMap.Entry)iter.next();
            result ^= entry.hashCode();
        }
        return result;
    }

    @Override
    protected Object clone() throws TCloneNotSupportedException {
        TAbstractMap copy = (TAbstractMap)super.clone();
        copy.cachedKeySet = null;
        copy.cachedValues = null;
        return copy;
    }

    private class Values
    extends TAbstractCollection<V> {
        private Values() {
        }

        @Override
        public int size() {
            return TAbstractMap.this.size();
        }

        @Override
        public TIterator<V> iterator() {
            final TIterator iter = TAbstractMap.this.entrySet().iterator();
            return new TIterator<V>(){

                @Override
                public boolean hasNext() {
                    return iter.hasNext();
                }

                @Override
                public V next() {
                    return ((TMap.Entry)iter.next()).getValue();
                }

                @Override
                public void remove() {
                    iter.remove();
                }
            };
        }
    }

    private class KeySet
    extends TAbstractSet<K> {
        private KeySet() {
        }

        @Override
        public TIterator<K> iterator() {
            final TIterator iter = TAbstractMap.this.entrySet().iterator();
            return new TIterator<K>(){

                @Override
                public boolean hasNext() {
                    return iter.hasNext();
                }

                @Override
                public K next() {
                    return ((TMap.Entry)iter.next()).getKey();
                }

                @Override
                public void remove() {
                    iter.remove();
                }
            };
        }

        @Override
        public int size() {
            return TAbstractMap.this.size();
        }
    }

    public static class SimpleImmutableEntry<K, V>
    implements TMap.Entry<K, V>,
    TSerializable {
        private K key;
        private V value;

        public SimpleImmutableEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public SimpleImmutableEntry(TMap.Entry<? extends K, ? extends V> entry) {
            this(entry.getKey(), entry.getValue());
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new TUnsupportedOperationException();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TMap.Entry)) {
                return false;
            }
            TMap.Entry other = (TMap.Entry)obj;
            if (this.getKey() == null ? other.getKey() != null : !this.getKey().equals(other.getKey())) {
                return false;
            }
            return this.getValue() == null ? other.getValue() == null : this.getValue().equals(other.getValue());
        }

        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        public String toString() {
            return String.valueOf(this.getKey()) + "=" + String.valueOf(this.getValue());
        }
    }

    public static class SimpleEntry<K, V>
    implements TMap.Entry<K, V>,
    TSerializable {
        private K key;
        private V value;

        public SimpleEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public SimpleEntry(TMap.Entry<? extends K, ? extends V> entry) {
            this(entry.getKey(), entry.getValue());
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V old = this.value;
            this.value = value;
            return old;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TMap.Entry)) {
                return false;
            }
            TMap.Entry other = (TMap.Entry)obj;
            if (this.getKey() == null ? other.getKey() != null : !this.getKey().equals(other.getKey())) {
                return false;
            }
            return this.getValue() == null ? other.getValue() == null : this.getValue().equals(other.getValue());
        }

        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        public String toString() {
            return String.valueOf(this.getKey()) + "=" + String.valueOf(this.getValue());
        }
    }
}

