/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.text;

import org.teavm.classlib.java.text.TDateFormatSymbols;
import org.teavm.classlib.java.text.TParsePosition;
import org.teavm.classlib.java.util.TCalendar;
import org.teavm.classlib.java.util.TGregorianCalendar;

abstract class TDateFormatElement {
    TDateFormatElement() {
    }

    public abstract void format(TCalendar var1, StringBuffer var2);

    public abstract void parse(String var1, TCalendar var2, TParsePosition var3);

    static boolean matches(String text, int position, String pattern) {
        if (pattern.length() + position > text.length()) {
            return false;
        }
        for (int i = 0; i < pattern.length(); ++i) {
            if (Character.toLowerCase(pattern.charAt(i)) == Character.toLowerCase(text.charAt(position++))) continue;
            return false;
        }
        return true;
    }

    static int whichMatches(String text, TParsePosition position, String[] patterns) {
        for (int i = 0; i < patterns.length; ++i) {
            if (!TDateFormatElement.matches(text, position.getIndex(), patterns[i])) continue;
            position.setIndex(position.getIndex() + patterns[i].length());
            return i;
        }
        return -1;
    }

    public static class ConstantText
    extends TDateFormatElement {
        private String textConstant;

        public ConstantText(String textConstant) {
            this.textConstant = textConstant;
        }

        @Override
        public void format(TCalendar date, StringBuffer buffer) {
            buffer.append(this.textConstant);
        }

        @Override
        public void parse(String text, TCalendar date, TParsePosition position) {
            if (ConstantText.matches(text, position.getIndex(), this.textConstant)) {
                position.setIndex(position.getIndex() + this.textConstant.length());
            } else {
                position.setErrorIndex(position.getIndex());
            }
        }
    }

    public static class Year
    extends TDateFormatElement {
        private int field;

        public Year(int field) {
            this.field = field;
        }

        @Override
        public void format(TCalendar date, StringBuffer buffer) {
            int number = date.get(this.field);
            if (number < 10) {
                buffer.append(number);
            } else {
                buffer.append((char)(number % 100 / 10 + 48));
                buffer.append((char)(number % 10 + 48));
            }
        }

        @Override
        public void parse(String text, TCalendar date, TParsePosition position) {
            char c;
            int num = 0;
            int pos = position.getIndex();
            if ((c = text.charAt(pos++)) < '0' || c > '9') {
                position.setErrorIndex(position.getErrorIndex());
                return;
            }
            num = c - 48;
            c = text.charAt(pos);
            if (c >= '0' && c <= '9') {
                num = num * 10 + (c - 48);
                ++pos;
            }
            position.setIndex(pos);
            TGregorianCalendar calendar = new TGregorianCalendar();
            int currentYear = calendar.get(1);
            int currentShortYear = currentYear % 100;
            int century = currentYear / 100;
            if (currentShortYear > 80) {
                if (num < currentShortYear - 80) {
                    ++century;
                }
            } else if (num > currentShortYear + 20) {
                --century;
            }
            date.set(this.field, num + century * 100);
        }
    }

    public static class NumericHour
    extends Numeric {
        private int limit;

        public NumericHour(int field, int length, int limit) {
            super(field, length);
            this.limit = limit;
        }

        @Override
        protected int processBeforeFormat(int num) {
            return num == 0 ? this.limit : num;
        }

        @Override
        protected int processAfterParse(int num) {
            return num == this.limit ? 0 : num;
        }
    }

    public static class NumericWeekday
    extends Numeric {
        public NumericWeekday(int length) {
            super(7, length);
        }

        @Override
        protected int processBeforeFormat(int num) {
            return num == 1 ? 7 : num - 1;
        }

        @Override
        protected int processAfterParse(int num) {
            return num == 7 ? 1 : num + 1;
        }
    }

    public static class NumericMonth
    extends Numeric {
        public NumericMonth(int length) {
            super(2, length);
        }

        @Override
        protected int processBeforeFormat(int num) {
            return num + 1;
        }

        @Override
        protected int processAfterParse(int num) {
            return num - 1;
        }
    }

    public static class Numeric
    extends TDateFormatElement {
        private int field;
        private int length;

        public Numeric(int field, int length) {
            this.field = field;
            this.length = length;
        }

        @Override
        public void format(TCalendar date, StringBuffer buffer) {
            int number = this.processBeforeFormat(date.get(this.field));
            String str = Integer.toString(number);
            for (int i = str.length(); i < this.length; ++i) {
                buffer.append('0');
            }
            buffer.append(str);
        }

        @Override
        public void parse(String text, TCalendar date, TParsePosition position) {
            char c;
            int num = 0;
            int i = 0;
            int pos = position.getIndex();
            while (pos < text.length() && (c = text.charAt(pos)) >= '0' && c <= '9') {
                num = num * 10 + (c - 48);
                ++pos;
                ++i;
            }
            if (i < this.length) {
                position.setErrorIndex(position.getIndex());
                return;
            }
            position.setIndex(pos);
            date.set(this.field, this.processAfterParse(num));
        }

        protected int processBeforeFormat(int num) {
            return num;
        }

        protected int processAfterParse(int num) {
            return num;
        }
    }

    public static class AmPmText
    extends TDateFormatElement {
        String[] ampms;

        public AmPmText(TDateFormatSymbols symbols) {
            this.ampms = symbols.getAmPmStrings();
        }

        @Override
        public void format(TCalendar date, StringBuffer buffer) {
            int ampm = date.get(9);
            buffer.append(this.ampms[ampm]);
        }

        @Override
        public void parse(String text, TCalendar date, TParsePosition position) {
            int ampm = AmPmText.whichMatches(text, position, this.ampms);
            if (ampm < 0) {
                position.setErrorIndex(position.getIndex());
            } else {
                date.set(9, ampm);
            }
        }
    }

    public static class EraText
    extends TDateFormatElement {
        String[] eras;

        public EraText(TDateFormatSymbols symbols) {
            this.eras = symbols.getEras();
        }

        @Override
        public void format(TCalendar date, StringBuffer buffer) {
            int era = date.get(0);
            buffer.append(this.eras[era]);
        }

        @Override
        public void parse(String text, TCalendar date, TParsePosition position) {
            int era = EraText.whichMatches(text, position, this.eras);
            if (era < 0) {
                position.setErrorIndex(position.getIndex());
            } else {
                date.set(0, era);
            }
        }
    }

    public static class WeekdayText
    extends TDateFormatElement {
        String[] weeks;
        String[] shortWeeks;
        boolean abbreviated;

        public WeekdayText(TDateFormatSymbols symbols, boolean abbreviated) {
            this.weeks = symbols.getWeekdays();
            this.shortWeeks = symbols.getShortWeekdays();
            this.abbreviated = abbreviated;
        }

        @Override
        public void format(TCalendar date, StringBuffer buffer) {
            int weekday = date.get(7) - 1;
            buffer.append(this.abbreviated ? this.shortWeeks[weekday] : this.weeks[weekday]);
        }

        @Override
        public void parse(String text, TCalendar date, TParsePosition position) {
            int weekday = WeekdayText.whichMatches(text, position, this.weeks);
            if (weekday < 0) {
                weekday = WeekdayText.whichMatches(text, position, this.shortWeeks);
            }
            if (weekday < 0) {
                position.setErrorIndex(position.getIndex());
            } else {
                date.set(4, weekday + 1);
            }
        }
    }

    public static class MonthText
    extends TDateFormatElement {
        String[] months;
        String[] shortMonths;
        boolean abbreviated;

        public MonthText(TDateFormatSymbols symbols, boolean abbreviated) {
            this.months = symbols.getMonths();
            this.shortMonths = symbols.getShortMonths();
            this.abbreviated = abbreviated;
        }

        @Override
        public void format(TCalendar date, StringBuffer buffer) {
            int month = date.get(2);
            buffer.append(this.abbreviated ? this.shortMonths[month] : this.months[month]);
        }

        @Override
        public void parse(String text, TCalendar date, TParsePosition position) {
            int month = MonthText.whichMatches(text, position, this.months);
            if (month < 0) {
                month = MonthText.whichMatches(text, position, this.shortMonths);
            }
            if (month < 0) {
                position.setErrorIndex(position.getIndex());
            } else {
                date.set(2, month);
            }
        }
    }
}

