/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import org.teavm.classlib.java.io.TPrintStream;
import org.teavm.classlib.java.lang.SystemNativeGenerator;
import org.teavm.classlib.java.lang.TArrayStoreException;
import org.teavm.classlib.java.lang.TConsoleOutputStream_stderr;
import org.teavm.classlib.java.lang.TConsoleOutputStream_stdout;
import org.teavm.classlib.java.lang.TIndexOutOfBoundsException;
import org.teavm.classlib.java.lang.TNullPointerException;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.TString;
import org.teavm.classlib.java.lang.reflect.TArray;
import org.teavm.dependency.PluggableDependency;
import org.teavm.javascript.ni.GeneratedBy;

public final class TSystem
extends TObject {
    public static final TPrintStream out = new TPrintStream(new TConsoleOutputStream_stdout(), false);
    public static final TPrintStream err = new TPrintStream(new TConsoleOutputStream_stderr(), false);

    private TSystem() {
    }

    public static void arraycopy(TObject src, int srcPos, TObject dest, int destPos, int length) {
        if (src == null || dest == null) {
            throw new TNullPointerException(TString.wrap("Either src or dest is null"));
        }
        if (src.getClass() != dest.getClass()) {
            throw new TArrayStoreException();
        }
        if (srcPos < 0 || destPos < 0 || length < 0 || srcPos + length > TArray.getLength(src) || destPos + length > TArray.getLength(dest)) {
            throw new TIndexOutOfBoundsException();
        }
        TSystem.doArrayCopy(src, srcPos, dest, destPos, length);
    }

    @GeneratedBy(value=SystemNativeGenerator.class)
    private static native void doArrayCopy(Object var0, int var1, Object var2, int var3, int var4);

    @GeneratedBy(value=SystemNativeGenerator.class)
    public static native long currentTimeMillis();

    public static TString getProperty(TString key) {
        return null;
    }

    public static TString getProperty(TString key, TString def) {
        TString value = TSystem.getProperty(key);
        return value != null ? value : def;
    }

    @GeneratedBy(value=SystemNativeGenerator.class)
    @PluggableDependency(value=SystemNativeGenerator.class)
    public static native void setErr(TPrintStream var0);

    @GeneratedBy(value=SystemNativeGenerator.class)
    @PluggableDependency(value=SystemNativeGenerator.class)
    public static native void setOut(TPrintStream var0);

    public static void gc() {
    }

    public static void runFinalization() {
    }

    public static long nanoTime() {
        return TSystem.currentTimeMillis() * 10000000L;
    }

    @GeneratedBy(value=SystemNativeGenerator.class)
    @PluggableDependency(value=SystemNativeGenerator.class)
    public static native int identityHashCode(Object var0);

    public static TString lineSeparator() {
        return TString.wrap("\n");
    }
}

