/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.unicode;

import org.teavm.classlib.impl.FirstDayOfWeekMetadataGenerator;
import org.teavm.classlib.impl.MinimalDaysInFirstWeekMetadataGenerator;
import org.teavm.classlib.impl.unicode.AvailableLocalesMetadataGenerator;
import org.teavm.classlib.impl.unicode.CLDRDecimalData;
import org.teavm.classlib.impl.unicode.CountryMetadataGenerator;
import org.teavm.classlib.impl.unicode.DateFormatCollection;
import org.teavm.classlib.impl.unicode.DateFormatMetadataGenerator;
import org.teavm.classlib.impl.unicode.DateSymbolsMetadataGenerator;
import org.teavm.classlib.impl.unicode.DefaultLocaleMetadataGenerator;
import org.teavm.classlib.impl.unicode.LanguageMetadataGenerator;
import org.teavm.classlib.impl.unicode.LikelySubtagsMetadataGenerator;
import org.teavm.platform.metadata.IntResource;
import org.teavm.platform.metadata.MetadataProvider;
import org.teavm.platform.metadata.ResourceArray;
import org.teavm.platform.metadata.ResourceMap;
import org.teavm.platform.metadata.StringResource;

public class CLDRHelper {
    public static String getCode(String language, String country) {
        return !country.isEmpty() ? language + "-" + country : language;
    }

    public static String getLikelySubtags(String localeCode) {
        ResourceMap<StringResource> map = CLDRHelper.getLikelySubtagsMap();
        return map.has(localeCode) ? ((StringResource)map.get(localeCode)).getValue() : localeCode;
    }

    @MetadataProvider(value=LikelySubtagsMetadataGenerator.class)
    private static native ResourceMap<StringResource> getLikelySubtagsMap();

    public static String[] resolveEras(String language, String country) {
        return CLDRHelper.resolveDateFormatSymbols(CLDRHelper.getErasMap(), language, country);
    }

    @MetadataProvider(value=DateSymbolsMetadataGenerator.class)
    private static native ResourceMap<ResourceArray<StringResource>> getErasMap();

    public static String[] resolveAmPm(String language, String country) {
        return CLDRHelper.resolveDateFormatSymbols(CLDRHelper.getAmPmMap(), language, country);
    }

    @MetadataProvider(value=DateSymbolsMetadataGenerator.class)
    private static native ResourceMap<ResourceArray<StringResource>> getAmPmMap();

    public static String[] resolveMonths(String language, String country) {
        return CLDRHelper.resolveDateFormatSymbols(CLDRHelper.getMonthMap(), language, country);
    }

    @MetadataProvider(value=DateSymbolsMetadataGenerator.class)
    private static native ResourceMap<ResourceArray<StringResource>> getMonthMap();

    public static String[] resolveShortMonths(String language, String country) {
        return CLDRHelper.resolveDateFormatSymbols(CLDRHelper.getShortMonthMap(), language, country);
    }

    @MetadataProvider(value=DateSymbolsMetadataGenerator.class)
    private static native ResourceMap<ResourceArray<StringResource>> getShortMonthMap();

    public static String[] resolveWeekdays(String language, String country) {
        return CLDRHelper.resolveDateFormatSymbols(CLDRHelper.getWeekdayMap(), language, country);
    }

    @MetadataProvider(value=DateSymbolsMetadataGenerator.class)
    private static native ResourceMap<ResourceArray<StringResource>> getWeekdayMap();

    public static String[] resolveShortWeekdays(String language, String country) {
        return CLDRHelper.resolveDateFormatSymbols(CLDRHelper.getShortWeekdayMap(), language, country);
    }

    @MetadataProvider(value=DateSymbolsMetadataGenerator.class)
    private static native ResourceMap<ResourceArray<StringResource>> getShortWeekdayMap();

    private static String[] resolveDateFormatSymbols(ResourceMap<ResourceArray<StringResource>> map, String language, String country) {
        String localeCode = CLDRHelper.getCode(language, country);
        ResourceArray arrayRes = map.has(localeCode) ? (ResourceArray)map.get(localeCode) : (map.has(language) ? (ResourceArray)map.get(language) : (ResourceArray)map.get("root"));
        String[] result = new String[arrayRes.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((StringResource)arrayRes.get(i)).getValue();
        }
        return result;
    }

    @MetadataProvider(value=LanguageMetadataGenerator.class)
    public static native ResourceMap<ResourceMap<StringResource>> getLanguagesMap();

    @MetadataProvider(value=CountryMetadataGenerator.class)
    public static native ResourceMap<ResourceMap<StringResource>> getCountriesMap();

    @MetadataProvider(value=DefaultLocaleMetadataGenerator.class)
    public static native StringResource getDefaultLocale();

    @MetadataProvider(value=AvailableLocalesMetadataGenerator.class)
    public static native ResourceArray<StringResource> getAvailableLocales();

    @MetadataProvider(value=MinimalDaysInFirstWeekMetadataGenerator.class)
    public static native ResourceMap<IntResource> getMinimalDaysInFirstWeek();

    @MetadataProvider(value=FirstDayOfWeekMetadataGenerator.class)
    public static native ResourceMap<IntResource> getFirstDayOfWeek();

    public static DateFormatCollection resolveDateFormats(String language, String country) {
        return CLDRHelper.resolveDateFormats(CLDRHelper.getDateFormatMap(), language, country);
    }

    @MetadataProvider(value=DateFormatMetadataGenerator.class)
    private static native ResourceMap<DateFormatCollection> getDateFormatMap();

    public static DateFormatCollection resolveTimeFormats(String language, String country) {
        return CLDRHelper.resolveDateFormats(CLDRHelper.getTimeFormatMap(), language, country);
    }

    @MetadataProvider(value=DateFormatMetadataGenerator.class)
    private static native ResourceMap<DateFormatCollection> getTimeFormatMap();

    public static DateFormatCollection resolveDateTimeFormats(String language, String country) {
        return CLDRHelper.resolveDateFormats(CLDRHelper.getDateTimeFormatMap(), language, country);
    }

    @MetadataProvider(value=DateFormatMetadataGenerator.class)
    private static native ResourceMap<DateFormatCollection> getDateTimeFormatMap();

    public static String resolveNumberFormat(String language, String country) {
        return CLDRHelper.resolveFormatSymbols(CLDRHelper.getNumberFormatMap(), language, country);
    }

    private static native ResourceMap<StringResource> getNumberFormatMap();

    public static String resolveDecimalFormat(String language, String country) {
        return CLDRHelper.resolveFormatSymbols(CLDRHelper.getDecimalFormatMap(), language, country);
    }

    private static native ResourceMap<StringResource> getDecimalFormatMap();

    public static String resolvePercentFormat(String language, String country) {
        return CLDRHelper.resolveFormatSymbols(CLDRHelper.getPercentFormatMap(), language, country);
    }

    private static native ResourceMap<StringResource> getPercentFormatMap();

    private static DateFormatCollection resolveDateFormats(ResourceMap<DateFormatCollection> map, String language, String country) {
        String localeCode = CLDRHelper.getCode(language, country);
        return map.has(localeCode) ? (DateFormatCollection)map.get(localeCode) : (map.has(language) ? (DateFormatCollection)map.get(language) : (DateFormatCollection)map.get("root"));
    }

    private static String resolveFormatSymbols(ResourceMap<StringResource> map, String language, String country) {
        String localeCode = CLDRHelper.getCode(language, country);
        StringResource res = map.has(localeCode) ? (StringResource)map.get(localeCode) : (map.has(language) ? (StringResource)map.get(language) : (StringResource)map.get("root"));
        return res.getValue();
    }

    public static CLDRDecimalData resolveDecimalData(String language, String country) {
        String localeCode;
        ResourceMap<CLDRDecimalData> map = CLDRHelper.getDecimalDataMap();
        return map.has(localeCode = CLDRHelper.getCode(language, country)) ? (CLDRDecimalData)map.get(localeCode) : (map.has(language) ? (CLDRDecimalData)map.get(language) : (CLDRDecimalData)map.get("root"));
    }

    private static native ResourceMap<CLDRDecimalData> getDecimalDataMap();
}

