/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.charset;

public class CharBuffer {
    private char[] data;
    private int end;
    private int pos;

    public CharBuffer(char[] data, int start, int end) {
        this.data = data;
        this.end = end;
        this.pos = start;
    }

    public CharBuffer(char[] data) {
        this(data, 0, data.length);
    }

    public void put(char b) {
        this.data[this.pos++] = b;
    }

    public void rewind(int start) {
        this.pos = start;
    }

    public int available() {
        return this.end - this.pos;
    }

    public void back(int count) {
        this.pos -= count;
    }

    public boolean end() {
        return this.pos == this.end;
    }

    public char get() {
        return this.data[this.pos++];
    }

    public int position() {
        return this.pos;
    }

    public void skip(int count) {
        this.pos += count;
    }

    public void put(CharBuffer buffer) {
        int sz = Math.min(buffer.end - buffer.pos, this.end - this.pos);
        for (int i = 0; i < sz; ++i) {
            this.data[this.pos++] = buffer.data[buffer.pos++];
        }
    }
}

