/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl;

import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyAgentType;
import org.teavm.dependency.DependencyConsumer;
import org.teavm.dependency.DependencyListener;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.DependencyStack;
import org.teavm.dependency.FieldDependency;
import org.teavm.dependency.MethodDependency;
import org.teavm.model.ClassReader;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class ClassLookupDependencySupport
implements DependencyListener {
    private DependencyNode allClasses;

    public void started(DependencyAgent agent) {
        this.allClasses = agent.createNode();
    }

    public void classAchieved(DependencyAgent agent, String className) {
        this.allClasses.propagate(agent.getType(className));
    }

    public void methodAchieved(final DependencyAgent agent, MethodDependency method) {
        MethodReference ref = method.getReference();
        if (ref.getClassName().equals("java.lang.Class") && ref.getName().equals("forNameImpl")) {
            final DependencyStack stack = method.getStack();
            this.allClasses.addConsumer(new DependencyConsumer(){

                public void consume(DependencyAgentType type) {
                    ClassReader cls = agent.getClassSource().get(type.getName());
                    if (cls == null) {
                        return;
                    }
                    MethodReader initMethod = cls.getMethod(new MethodDescriptor("<clinit>", new ValueType[]{ValueType.VOID}));
                    if (initMethod != null) {
                        agent.linkMethod(initMethod.getReference(), stack).use();
                    }
                }
            });
        }
    }

    public void fieldAchieved(DependencyAgent dependencyChecker, FieldDependency field) {
    }
}

