/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream.longimpl;

import java.util.function.LongPredicate;
import org.teavm.classlib.java.util.stream.longimpl.TSimpleLongStreamImpl;

public class TLimitingLongStreamImpl
extends TSimpleLongStreamImpl {
    private TSimpleLongStreamImpl sourceStream;
    private int limit;
    private int remaining;

    public TLimitingLongStreamImpl(TSimpleLongStreamImpl sourceStream, int limit) {
        this.sourceStream = sourceStream;
        this.limit = limit;
        this.remaining = limit;
    }

    @Override
    public boolean next(LongPredicate consumer) {
        if (this.remaining == 0) {
            return false;
        }
        boolean result = this.sourceStream.next(e -> {
            boolean hasRemaining = --this.remaining > 0;
            return consumer.test(e) && hasRemaining;
        });
        if (!result) {
            this.remaining = 0;
        }
        return this.remaining > 0;
    }

    @Override
    protected int estimateSize() {
        int sourceEstimation = this.sourceStream.estimateSize();
        return sourceEstimation < 0 ? this.limit : Math.min(this.limit, sourceEstimation);
    }

    @Override
    public void close() throws Exception {
        this.sourceStream.close();
    }
}

