/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream.intimpl;

import java.util.function.IntPredicate;
import org.teavm.classlib.java.lang.TCharSequence;
import org.teavm.classlib.java.lang.TCharacter;
import org.teavm.classlib.java.util.stream.intimpl.TSimpleIntStreamImpl;

public class TCharSequenceCodePointsStream
extends TSimpleIntStreamImpl {
    private final TCharSequence csq;
    private int index;

    public TCharSequenceCodePointsStream(TCharSequence csq) {
        this.csq = csq;
    }

    @Override
    public boolean next(IntPredicate consumer) {
        while (this.index < this.csq.length()) {
            char lo;
            char hi;
            if (TCharacter.isHighSurrogate(hi = this.csq.charAt(this.index++)) && this.index < this.csq.length() && TCharacter.isLowSurrogate(lo = this.csq.charAt(this.index))) {
                ++this.index;
                if (consumer.test(TCharacter.toCodePoint(hi, lo))) continue;
                break;
            }
            if (consumer.test(hi)) continue;
            break;
        }
        return this.index < this.csq.length();
    }

    @Override
    protected int estimateSize() {
        return this.csq.length();
    }

    @Override
    public long count() {
        return this.csq.length();
    }
}

