/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TArrayBufferViewProvider;
import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TIntBuffer;
import org.teavm.classlib.java.nio.TIntBufferImpl;
import org.teavm.jso.typedarrays.ArrayBufferView;
import org.teavm.jso.typedarrays.DataView;
import org.teavm.jso.typedarrays.Int8Array;

class TIntBufferOverDataView
extends TIntBufferImpl
implements TArrayBufferViewProvider {
    private boolean readOnly;
    private DataView data;
    private boolean littleEndian;

    TIntBufferOverDataView(int position, int limit, boolean readOnly, DataView data, boolean littleEndian) {
        super(position, limit);
        this.readOnly = readOnly;
        this.data = data;
        this.littleEndian = littleEndian;
    }

    @Override
    TIntBuffer duplicate(int start, int capacity, int position, int limit, boolean readOnly) {
        DataView slice = new DataView(this.data.getBuffer(), this.data.getByteOffset() + start * 4, capacity * 4);
        return new TIntBufferOverDataView(position, limit, readOnly, slice, this.littleEndian);
    }

    @Override
    boolean readOnly() {
        return this.readOnly;
    }

    @Override
    int getElement(int index) {
        return this.data.getInt32(index * 4, this.littleEndian);
    }

    @Override
    void putElement(int index, int value) {
        this.data.setInt32(index * 4, value, this.littleEndian);
    }

    @Override
    void getImpl(int index, int[] dst, int offset, int length) {
        index *= 4;
        while (length-- > 0) {
            dst[offset++] = this.data.getInt32(index, this.littleEndian);
            index += 4;
        }
    }

    @Override
    void putImpl(int index, TIntBuffer src, int offset, int length) {
        if (src instanceof TIntBufferOverDataView) {
            TIntBufferOverDataView srcImpl = (TIntBufferOverDataView)src;
            Int8Array srcArray = new Int8Array(srcImpl.data.getBuffer(), srcImpl.data.getByteOffset() + offset * 4, length *= 4);
            Int8Array destArray = new Int8Array(this.data.getBuffer(), this.data.getByteOffset() + index * 4, length);
            destArray.set((ArrayBufferView)srcArray, 0);
        } else {
            index *= 4;
            while (length-- > 0) {
                this.data.setInt32(index, src.get(offset++), this.littleEndian);
                index += 4;
            }
        }
    }

    @Override
    void putImpl(int index, int[] src, int offset, int length) {
        index *= 4;
        while (length-- > 0) {
            this.data.setInt32(index, src[offset++], this.littleEndian);
            index += 4;
        }
    }

    @Override
    boolean isArrayPresent() {
        return false;
    }

    @Override
    int[] getArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    int getArrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TByteOrder order() {
        return this.littleEndian ? TByteOrder.LITTLE_ENDIAN : TByteOrder.BIG_ENDIAN;
    }

    @Override
    int capacityImpl() {
        return this.data.getByteLength() / 4;
    }

    @Override
    public ArrayBufferView getArrayBufferView() {
        return this.data;
    }

    @Override
    public int elementSize() {
        return 4;
    }
}

