/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TArrayBufferViewProvider;
import org.teavm.classlib.java.nio.TByteBufferNative;
import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TFloatBuffer;
import org.teavm.classlib.java.nio.TFloatBufferImpl;
import org.teavm.classlib.java.nio.TJSBufferHelper;
import org.teavm.classlib.java.nio.TNativeBufferObjectMarker;
import org.teavm.interop.Address;
import org.teavm.jso.typedarrays.ArrayBufferView;
import org.teavm.jso.typedarrays.Float32Array;

class TFloatBufferNative
extends TFloatBufferImpl
implements TArrayBufferViewProvider {
    Object gcRef;
    float[] array;
    boolean readOnly;
    @TNativeBufferObjectMarker
    protected final Object base;
    Address address;
    int capacity;
    boolean swap;

    TFloatBufferNative(Object gcRef, float[] array, int position, int limit, boolean readOnly, Object base, Address address, int capacity, boolean swap) {
        super(position, limit);
        this.gcRef = gcRef;
        this.array = array;
        this.readOnly = readOnly;
        this.base = base;
        this.address = address;
        this.capacity = capacity;
        this.swap = swap;
    }

    @Override
    int capacityImpl() {
        return this.capacity;
    }

    @Override
    boolean isArrayPresent() {
        return this.array != null;
    }

    @Override
    float[] getArray() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return this.array;
    }

    @Override
    int getArrayOffset() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return (int)(this.address.diff(Address.ofData((float[])this.array)) / 4L);
    }

    @Override
    boolean readOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isDirect() {
        return this.base == null;
    }

    @Override
    TFloatBuffer duplicate(int start, int capacity, int position, int limit, boolean readOnly) {
        return new TFloatBufferNative(this.gcRef, this.array, position, limit, readOnly, this.base, this.address.add(start * 4), capacity, this.swap);
    }

    @Override
    float getElement(int index) {
        Address addr = this.address.add(index * 4);
        return this.swap ? Float.intBitsToFloat(Integer.reverseBytes(addr.getInt())) : addr.getFloat();
    }

    @Override
    void putElement(int index, float value) {
        Address addr = this.address.add(index * 4);
        if (this.swap) {
            addr.putInt(Integer.reverseBytes(Float.floatToRawIntBits(value)));
        } else {
            addr.putFloat(value);
        }
    }

    @Override
    void getImpl(int index, float[] dst, int offset, int length) {
        Address addr = this.address.add(index * 4);
        if (this.swap) {
            while (length-- > 0) {
                dst[offset++] = Float.intBitsToFloat(Integer.reverseBytes(addr.getInt()));
                addr = addr.add(4);
            }
        } else {
            this.copy(addr, dst, offset, length);
        }
    }

    @Override
    void putImpl(int index, float[] src, int offset, int length) {
        Address addr = this.address.add(index * 4);
        if (this.swap) {
            while (length-- > 0) {
                addr.putInt(Integer.reverseBytes(Float.floatToRawIntBits(src[offset++])));
                addr = addr.add(4);
            }
        } else {
            this.copy(src, offset, addr, length);
        }
    }

    @Override
    void putImpl(int index, TFloatBuffer src, int offset, int length) {
        if (src instanceof TFloatBufferNative) {
            TFloatBufferNative srcImpl = (TFloatBufferNative)src;
            Address addr = this.address.add(index * 4);
            if (srcImpl.swap == this.swap) {
                TByteBufferNative.copy(srcImpl.address.add(offset * 4), addr, length * 4);
            } else {
                Address srcAddr = srcImpl.address.add(offset * 4);
                while (length-- > 0) {
                    addr.putInt(Integer.reverseBytes(Float.floatToRawIntBits(srcAddr.getFloat())));
                    addr = addr.add(4);
                    srcAddr = srcAddr.add(4);
                }
            }
        } else {
            Address addr = this.address.add(index * 4);
            if (this.swap) {
                while (length-- > 0) {
                    addr.putInt(Integer.reverseBytes(Float.floatToIntBits(src.get(offset++))));
                    addr = addr.add(4);
                }
            } else {
                while (length-- > 0) {
                    addr.putFloat(src.get(offset++));
                    addr = addr.add(4);
                }
            }
        }
    }

    @Override
    public TByteOrder order() {
        return this.swap ? TByteBufferNative.oppositeOrder(TByteOrder.nativeOrder()) : TByteOrder.nativeOrder();
    }

    @Override
    public ArrayBufferView getArrayBufferView() {
        return new Float32Array(TJSBufferHelper.WasmGC.getLinearMemory(), this.address.toInt(), this.capacity);
    }

    @Override
    public int elementSize() {
        return 4;
    }

    void copy(float[] from, int fromOffset, Address to, int count) {
        TByteBufferNative.copy(Address.ofData((float[])from).add(fromOffset * 4), to, count * 4);
    }

    void copy(Address from, float[] to, int toOffset, int count) {
        TByteBufferNative.copy(from, Address.ofData((float[])to).add(toOffset * 4), count * 4);
    }
}

