/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TArrayBufferViewProvider;
import org.teavm.classlib.java.nio.TByteBufferNative;
import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TDoubleBuffer;
import org.teavm.classlib.java.nio.TDoubleBufferImpl;
import org.teavm.classlib.java.nio.TJSBufferHelper;
import org.teavm.classlib.java.nio.TNativeBufferObjectMarker;
import org.teavm.interop.Address;
import org.teavm.jso.typedarrays.ArrayBufferView;
import org.teavm.jso.typedarrays.Float64Array;

class TDoubleBufferNative
extends TDoubleBufferImpl
implements TArrayBufferViewProvider {
    Object gcRef;
    double[] array;
    boolean readOnly;
    @TNativeBufferObjectMarker
    protected final Object base;
    Address address;
    int capacity;
    boolean swap;

    TDoubleBufferNative(Object gcRef, double[] array, int position, int limit, boolean readOnly, Object base, Address address, int capacity, boolean swap) {
        super(position, limit);
        this.gcRef = gcRef;
        this.array = array;
        this.readOnly = readOnly;
        this.base = base;
        this.address = address;
        this.capacity = capacity;
        this.swap = swap;
    }

    @Override
    int capacityImpl() {
        return this.capacity;
    }

    @Override
    boolean isArrayPresent() {
        return this.array != null;
    }

    @Override
    double[] getArray() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return this.array;
    }

    @Override
    int getArrayOffset() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return (int)(this.address.diff(Address.ofData((double[])this.array)) / 8L);
    }

    @Override
    boolean readOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isDirect() {
        return this.base == null;
    }

    @Override
    TDoubleBuffer duplicate(int start, int capacity, int position, int limit, boolean readOnly) {
        return new TDoubleBufferNative(this.gcRef, this.array, position, limit, readOnly, this.base, this.address.add(start * 8), capacity, this.swap);
    }

    @Override
    double getElement(int index) {
        Address addr = this.address.add(index * 8);
        return this.swap ? Double.longBitsToDouble(Long.reverseBytes(addr.getLong())) : addr.getDouble();
    }

    @Override
    void putElement(int index, double value) {
        Address addr = this.address.add(index * 8);
        if (this.swap) {
            addr.putLong(Long.reverseBytes(Double.doubleToRawLongBits(value)));
        } else {
            addr.putDouble(value);
        }
    }

    @Override
    void getImpl(int index, double[] dst, int offset, int length) {
        Address addr = this.address.add(index * 8);
        if (this.swap) {
            while (length-- > 0) {
                dst[offset++] = Double.longBitsToDouble(Long.reverseBytes(addr.getLong()));
                addr = addr.add(8);
            }
        } else {
            this.copy(addr, dst, offset, length);
        }
    }

    @Override
    void putImpl(int index, double[] src, int offset, int length) {
        Address addr = this.address.add(index * 8);
        if (this.swap) {
            while (length-- > 0) {
                addr.putLong(Long.reverseBytes(Double.doubleToRawLongBits(src[offset++])));
                addr = addr.add(8);
            }
        } else {
            this.copy(src, offset, addr, length);
        }
    }

    @Override
    void putImpl(int index, TDoubleBuffer src, int offset, int length) {
        if (src instanceof TDoubleBufferNative) {
            TDoubleBufferNative srcImpl = (TDoubleBufferNative)src;
            Address addr = this.address.add(index * 8);
            if (srcImpl.swap == this.swap) {
                TByteBufferNative.copy(srcImpl.address.add(offset * 8), addr, length * 8);
            } else {
                Address srcAddr = srcImpl.address.add(offset * 8);
                while (length-- > 0) {
                    addr.putLong(Long.reverseBytes(Double.doubleToRawLongBits(srcAddr.getDouble())));
                    addr = addr.add(8);
                    srcAddr = srcAddr.add(8);
                }
            }
        } else {
            Address addr = this.address.add(index * 8);
            if (this.swap) {
                while (length-- > 0) {
                    addr.putLong(Long.reverseBytes(Double.doubleToRawLongBits(src.get(offset++))));
                    addr = addr.add(8);
                }
            } else {
                while (length-- > 0) {
                    addr.putDouble(src.get(offset++));
                    addr = addr.add(8);
                }
            }
        }
    }

    @Override
    public TByteOrder order() {
        return this.swap ? TByteBufferNative.oppositeOrder(TByteOrder.nativeOrder()) : TByteOrder.nativeOrder();
    }

    @Override
    public ArrayBufferView getArrayBufferView() {
        return new Float64Array(TJSBufferHelper.WasmGC.getLinearMemory(), this.address.toInt(), this.capacity);
    }

    @Override
    public int elementSize() {
        return 8;
    }

    void copy(double[] from, int fromOffset, Address to, int count) {
        TByteBufferNative.copy(Address.ofData((double[])from).add(fromOffset * 8), to, count * 8);
    }

    void copy(Address from, double[] to, int toOffset, int count) {
        TByteBufferNative.copy(from, Address.ofData((double[])to).add(toOffset * 8), count * 8);
    }
}

