/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.reflection;

import org.teavm.backend.wasm.WasmFunctionTypes;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfoProvider;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCCustomTypeMapper;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.model.ValueType;

public class WasmGCReflectionTypeMapper
implements WasmGCCustomTypeMapper {
    private WasmGCClassInfoProvider classInfoProvider;
    private WasmFunctionTypes functionTypes;

    public WasmGCReflectionTypeMapper(WasmGCClassInfoProvider classInfoProvider, WasmFunctionTypes functionTypes) {
        this.classInfoProvider = classInfoProvider;
        this.functionTypes = functionTypes;
    }

    public WasmType map(String className) {
        switch (className) {
            case "org.teavm.classlib.impl.reflection.FieldInfo": {
                return this.classInfoProvider.reflection().getReflectionFieldType().getReference();
            }
            case "org.teavm.classlib.impl.reflection.FieldInfoList": {
                return this.classInfoProvider.reflection().getReflectionFieldArrayType().getReference();
            }
            case "org.teavm.classlib.impl.reflection.MethodInfo": {
                return this.classInfoProvider.reflection().getReflectionMethodType().getReference();
            }
            case "org.teavm.classlib.impl.reflection.MethodInfoList": {
                return this.classInfoProvider.reflection().getReflectionMethodArrayType().getReference();
            }
            case "org.teavm.classlib.impl.reflection.ClassList": {
                return this.classInfoProvider.reflection().getClassArrayType().getReference();
            }
            case "org.teavm.classlib.impl.reflection.FieldReader": {
                WasmType.CompositeReference objType = this.classInfoProvider.getClassInfo("java.lang.Object").getType();
                return this.functionTypes.of((WasmType)objType, new WasmType[]{objType}).getReference();
            }
            case "org.teavm.classlib.impl.reflection.FieldWriter": {
                WasmType.CompositeReference objType = this.classInfoProvider.getClassInfo("java.lang.Object").getType();
                return this.functionTypes.of(null, new WasmType[]{objType, objType}).getReference();
            }
            case "org.teavm.classlib.impl.reflection.MethodCaller": {
                WasmType.CompositeReference objType = this.classInfoProvider.getClassInfo("java.lang.Object").getType();
                WasmType.CompositeReference objArrayType = this.classInfoProvider.getClassInfo((ValueType)ValueType.arrayOf((ValueType)ValueType.object((String)"java.lang.Object"))).getType();
                return this.functionTypes.of((WasmType)objType, new WasmType[]{objType, objArrayType}).getReference();
            }
        }
        return null;
    }
}

