/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.concurrent;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TMap;

public interface TConcurrentMap<K, V>
extends TMap<K, V> {
    @Override
    default public V getOrDefault(Object key, V defaultValue) {
        Object result = this.get(key);
        return result != null ? result : defaultValue;
    }

    @Override
    default public void forEach(BiConsumer<? super K, ? super V> action) {
        Objects.requireNonNull(action);
        TIterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Object value;
            Object key;
            TMap.Entry entry = (TMap.Entry)iterator.next();
            try {
                key = entry.getKey();
                value = entry.getValue();
            }
            catch (IllegalStateException e) {
                continue;
            }
            action.accept(key, value);
        }
    }

    @Override
    public V putIfAbsent(K var1, V var2);

    @Override
    public boolean remove(Object var1, Object var2);

    @Override
    public boolean replace(K var1, V var2, V var3);

    @Override
    public V replace(K var1, V var2);

    @Override
    default public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        Objects.requireNonNull(function);
        TIterator iterator = this.entrySet().iterator();
        block2: while (iterator.hasNext()) {
            Object value;
            Object key;
            TMap.Entry entry = (TMap.Entry)iterator.next();
            do {
                try {
                    key = entry.getKey();
                    value = entry.getValue();
                }
                catch (IllegalStateException e) {
                    continue block2;
                }
            } while (!this.replace(key, value, function.apply(key, value)));
        }
    }

    @Override
    default public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        Object oldValue = this.get(key);
        if (oldValue == null) {
            V newValue = mappingFunction.apply(key);
            return newValue != null ? (V)this.putIfAbsent(key, newValue) : null;
        }
        return oldValue;
    }

    @Override
    default public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        while (true) {
            Object oldValue;
            if ((oldValue = this.get(key)) == null) {
                return null;
            }
            V newValue = remappingFunction.apply(key, oldValue);
            if (newValue != null) {
                if (!this.replace(key, oldValue, newValue)) continue;
                return newValue;
            }
            if (this.remove(key, oldValue)) break;
        }
        return null;
    }

    @Override
    default public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        V newValue;
        Object oldValue;
        Objects.requireNonNull(remappingFunction);
        do {
            oldValue = this.get(key);
            newValue = remappingFunction.apply(key, oldValue);
        } while (!(oldValue != null ? (newValue != null ? this.replace(key, oldValue, newValue) : this.remove(key, oldValue)) : newValue == null || this.putIfAbsent(key, newValue) == null));
        return newValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    default public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        while (true) {
            Object oldValue;
            V newValue;
            V v = newValue = (oldValue = this.get(key)) == null ? value : remappingFunction.apply(oldValue, value);
            if (newValue == null) {
                if (oldValue == null) return newValue;
                this.remove(key, oldValue);
                continue;
            }
            if (oldValue == null ? this.putIfAbsent(key, newValue) == null : this.replace(key, oldValue, newValue)) return newValue;
        }
    }
}

