/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Objects;
import org.teavm.classlib.java.io.TSerializable;
import org.teavm.classlib.java.lang.TCloneNotSupportedException;
import org.teavm.classlib.java.lang.TCloneable;
import org.teavm.classlib.java.util.TAbstractList;
import org.teavm.classlib.java.util.TCollection;
import org.teavm.classlib.java.util.TEnumeration;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TList;
import org.teavm.classlib.java.util.TNoSuchElementException;
import org.teavm.classlib.java.util.TRandomAccess;

public class TVector<E>
extends TAbstractList<E>
implements TList<E>,
TRandomAccess,
TCloneable,
TSerializable {
    protected int elementCount;
    protected Object[] elementData;
    protected int capacityIncrement;
    private static final int DEFAULT_SIZE = 10;

    public TVector() {
        this(10, 0);
    }

    public TVector(int capacity) {
        this(capacity, 0);
    }

    public TVector(int capacity, int capacityIncrement) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.elementData = new Object[capacity];
        this.elementCount = 0;
        this.capacityIncrement = capacityIncrement;
    }

    public TVector(TCollection<? extends E> collection) {
        this(collection.size(), 0);
        TIterator it = collection.iterator();
        while (it.hasNext()) {
            this.elementData[this.elementCount++] = it.next();
        }
    }

    @Override
    public void add(int location, E object) {
        this.insertElementAt(object, location);
    }

    @Override
    public synchronized boolean add(E object) {
        if (this.elementCount == this.elementData.length) {
            this.growByOne();
        }
        this.elementData[this.elementCount++] = object;
        ++this.modCount;
        return true;
    }

    @Override
    public synchronized boolean addAll(int location, TCollection<? extends E> collection) {
        if (0 <= location && location <= this.elementCount) {
            int count;
            int size = collection.size();
            if (size == 0) {
                return false;
            }
            int required = size - (this.elementData.length - this.elementCount);
            if (required > 0) {
                this.growBy(required);
            }
            if ((count = this.elementCount - location) > 0) {
                System.arraycopy(this.elementData, location, this.elementData, location + size, count);
            }
            TIterator it = collection.iterator();
            while (it.hasNext()) {
                this.elementData[location++] = it.next();
            }
            this.elementCount += size;
            ++this.modCount;
            return true;
        }
        throw new ArrayIndexOutOfBoundsException(location);
    }

    @Override
    public synchronized boolean addAll(TCollection<? extends E> collection) {
        return this.addAll(this.elementCount, collection);
    }

    public synchronized void addElement(E object) {
        if (this.elementCount == this.elementData.length) {
            this.growByOne();
        }
        this.elementData[this.elementCount++] = object;
        ++this.modCount;
    }

    public synchronized int capacity() {
        return this.elementData.length;
    }

    @Override
    public void clear() {
        this.removeAllElements();
    }

    @Override
    public synchronized Object clone() {
        try {
            TVector vector = (TVector)super.clone();
            vector.elementData = (Object[])this.elementData.clone();
            return vector;
        }
        catch (TCloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object, 0) != -1;
    }

    @Override
    public synchronized boolean containsAll(TCollection<?> collection) {
        return super.containsAll(collection);
    }

    public synchronized void copyInto(Object[] elements) {
        System.arraycopy(this.elementData, 0, elements, 0, this.elementCount);
    }

    public synchronized E elementAt(int location) {
        if (location < this.elementCount) {
            return (E)this.elementData[location];
        }
        throw new ArrayIndexOutOfBoundsException(location);
    }

    public TEnumeration<E> elements() {
        return new TEnumeration<E>(){
            int pos;

            @Override
            public boolean hasMoreElements() {
                return this.pos < TVector.this.elementCount;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public E nextElement() {
                TVector tVector = TVector.this;
                synchronized (tVector) {
                    if (this.pos < TVector.this.elementCount) {
                        return TVector.this.elementData[this.pos++];
                    }
                }
                throw new TNoSuchElementException();
            }
        };
    }

    public synchronized void ensureCapacity(int minimumCapacity) {
        if (this.elementData.length < minimumCapacity) {
            int next = (this.capacityIncrement <= 0 ? this.elementData.length : this.capacityIncrement) + this.elementData.length;
            this.grow(Math.max(minimumCapacity, next));
        }
    }

    @Override
    public synchronized boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TList) {
            TList list = (TList)object;
            if (list.size() != this.elementCount) {
                return false;
            }
            int index = 0;
            TIterator it = list.iterator();
            while (it.hasNext()) {
                Object e1;
                Object e2 = it.next();
                if (Objects.equals(e1 = this.elementData[index++], e2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public synchronized E firstElement() {
        if (this.elementCount > 0) {
            return (E)this.elementData[0];
        }
        throw new TNoSuchElementException();
    }

    @Override
    public E get(int location) {
        return this.elementAt(location);
    }

    private void grow(int newCapacity) {
        Object[] newData = new Object[newCapacity];
        assert (this.elementCount <= newCapacity);
        System.arraycopy(this.elementData, 0, newData, 0, this.elementCount);
        this.elementData = newData;
    }

    private void growByOne() {
        int adding = 0;
        if (this.capacityIncrement <= 0) {
            adding = this.elementData.length;
            if (adding == 0) {
                adding = 1;
            }
        } else {
            adding = this.capacityIncrement;
        }
        Object[] newData = new Object[this.elementData.length + adding];
        System.arraycopy(this.elementData, 0, newData, 0, this.elementCount);
        this.elementData = newData;
    }

    private void growBy(int required) {
        int adding;
        if (this.capacityIncrement <= 0) {
            adding = this.elementData.length;
            if (adding == 0) {
                adding = required;
            }
            while (adding < required) {
                adding *= 2;
            }
        } else {
            adding = required / this.capacityIncrement * this.capacityIncrement;
            if (adding < required) {
                adding += this.capacityIncrement;
            }
        }
        Object[] newData = new Object[this.elementData.length + adding];
        System.arraycopy(this.elementData, 0, newData, 0, this.elementCount);
        this.elementData = newData;
    }

    @Override
    public synchronized int hashCode() {
        int result = 1;
        for (int i = 0; i < this.elementCount; ++i) {
            result = 31 * result + Objects.hashCode(this.elementData[i]);
        }
        return result;
    }

    @Override
    public int indexOf(Object object) {
        return this.indexOf(object, 0);
    }

    public synchronized int indexOf(Object object, int location) {
        if (location < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (object != null) {
            for (int i = location; i < this.elementCount; ++i) {
                if (!object.equals(this.elementData[i])) continue;
                return i;
            }
        } else {
            for (int i = location; i < this.elementCount; ++i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        }
        return -1;
    }

    public synchronized void insertElementAt(E object, int location) {
        if (0 <= location && location <= this.elementCount) {
            int count;
            if (this.elementCount == this.elementData.length) {
                this.growByOne();
            }
            if ((count = this.elementCount - location) > 0) {
                System.arraycopy(this.elementData, location, this.elementData, location + 1, count);
            }
            this.elementData[location] = object;
            ++this.elementCount;
            ++this.modCount;
        } else {
            throw new ArrayIndexOutOfBoundsException(location);
        }
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.elementCount == 0;
    }

    public synchronized E lastElement() {
        if (this.isEmpty()) {
            throw new TNoSuchElementException();
        }
        return (E)this.elementData[this.elementCount - 1];
    }

    @Override
    public synchronized int lastIndexOf(Object object) {
        return this.lastIndexOf(object, this.elementCount - 1);
    }

    public synchronized int lastIndexOf(Object object, int location) {
        if (location < 0) {
            return -1;
        }
        if (location < this.elementCount) {
            if (object != null) {
                for (int i = location; i >= 0; --i) {
                    if (!object.equals(this.elementData[i])) continue;
                    return i;
                }
            } else {
                for (int i = location; i >= 0; --i) {
                    if (this.elementData[i] != null) continue;
                    return i;
                }
            }
            return -1;
        }
        throw new ArrayIndexOutOfBoundsException(location);
    }

    @Override
    public synchronized E remove(int location) {
        if (location < this.elementCount && location >= 0) {
            Object result = this.elementData[location];
            --this.elementCount;
            int size = this.elementCount - location;
            if (size > 0) {
                System.arraycopy(this.elementData, location + 1, this.elementData, location, size);
            }
            this.elementData[this.elementCount] = null;
            ++this.modCount;
            return (E)result;
        }
        throw new ArrayIndexOutOfBoundsException(location);
    }

    @Override
    public boolean remove(Object object) {
        return this.removeElement(object);
    }

    @Override
    public synchronized boolean removeAll(TCollection<?> collection) {
        return super.removeAll(collection);
    }

    public synchronized void removeAllElements() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = null;
        }
        ++this.modCount;
        this.elementCount = 0;
    }

    public synchronized boolean removeElement(Object object) {
        int index = this.indexOf(object, 0);
        if (index == -1) {
            return false;
        }
        this.removeElementAt(index);
        return true;
    }

    public synchronized void removeElementAt(int location) {
        if (0 <= location && location < this.elementCount) {
            --this.elementCount;
            int size = this.elementCount - location;
            if (size > 0) {
                System.arraycopy(this.elementData, location + 1, this.elementData, location, size);
            }
            this.elementData[this.elementCount] = null;
            ++this.modCount;
        } else {
            throw new ArrayIndexOutOfBoundsException(location);
        }
    }

    @Override
    protected void removeRange(int start, int end) {
        if (start >= 0 && start <= end && end <= this.elementCount) {
            if (start == end) {
                return;
            }
            if (end != this.elementCount) {
                System.arraycopy(this.elementData, end, this.elementData, start, this.elementCount - end);
                int newCount = this.elementCount - (end - start);
                Arrays.fill(this.elementData, newCount, this.elementCount, null);
                this.elementCount = newCount;
            } else {
                Arrays.fill(this.elementData, start, this.elementCount, null);
                this.elementCount = start;
            }
            ++this.modCount;
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public synchronized boolean retainAll(TCollection<?> collection) {
        return super.retainAll(collection);
    }

    @Override
    public synchronized E set(int location, E object) {
        if (location >= 0 && location < this.elementCount) {
            Object result = this.elementData[location];
            this.elementData[location] = object;
            return (E)result;
        }
        throw new ArrayIndexOutOfBoundsException(location);
    }

    public synchronized void setElementAt(E object, int location) {
        if (location >= this.elementCount || location < 0) {
            throw new ArrayIndexOutOfBoundsException(location);
        }
        this.elementData[location] = object;
    }

    public synchronized void setSize(int length) {
        if (length < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (length == this.elementCount) {
            return;
        }
        this.ensureCapacity(length);
        if (this.elementCount > length) {
            Arrays.fill(this.elementData, length, this.elementCount, null);
        }
        this.elementCount = length;
        ++this.modCount;
    }

    @Override
    public synchronized int size() {
        return this.elementCount;
    }

    @Override
    public synchronized Object[] toArray() {
        Object[] result = new Object[this.elementCount];
        System.arraycopy(this.elementData, 0, result, 0, this.elementCount);
        return result;
    }

    @Override
    public synchronized <T> T[] toArray(T[] contents) {
        if (this.elementCount > contents.length) {
            Class<?> ct = contents.getClass().getComponentType();
            contents = (Object[])Array.newInstance(ct, this.elementCount);
        }
        System.arraycopy(this.elementData, 0, contents, 0, this.elementCount);
        if (this.elementCount < contents.length) {
            contents[this.elementCount] = null;
        }
        return contents;
    }

    @Override
    public synchronized String toString() {
        if (this.elementCount == 0) {
            return "[]";
        }
        int length = this.elementCount - 1;
        StringBuilder buffer = new StringBuilder(this.elementCount * 16);
        buffer.append('[');
        for (int i = 0; i < length; ++i) {
            if (this.elementData[i] == this) {
                buffer.append("(this Collection)");
            } else {
                buffer.append(this.elementData[i]);
            }
            buffer.append(", ");
        }
        if (this.elementData[length] == this) {
            buffer.append("(this Collection)");
        } else {
            buffer.append(this.elementData[length]);
        }
        buffer.append(']');
        return buffer.toString();
    }

    public synchronized void trimToSize() {
        if (this.elementData.length != this.elementCount) {
            this.grow(this.elementCount);
        }
    }
}

