/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import org.teavm.classlib.java.lang.TBoolean;
import org.teavm.classlib.java.util.TAbstractSet;
import org.teavm.classlib.java.util.TCollection;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TLinkedHashMap;
import org.teavm.classlib.java.util.TMap;
import org.teavm.classlib.java.util.TSequencedMap;
import org.teavm.classlib.java.util.TSequencedSet;

class TSetFromMap<E>
extends TAbstractSet<E> {
    private TMap<E, TBoolean> map;

    TSetFromMap(TMap<E, TBoolean> map) {
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, TBoolean.TRUE) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public boolean removeAll(TCollection<?> c) {
        return this.map.keySet().removeAll(c);
    }

    @Override
    public boolean retainAll(TCollection<?> c) {
        return this.map.keySet().retainAll(c);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public TIterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    static class SequencedSetFromMap<E>
    extends TSetFromMap<E>
    implements TSequencedSet<E> {
        SequencedSetFromMap(TSequencedMap<E, TBoolean> map) {
            super(map);
        }

        private TSequencedMap<E, TBoolean> map() {
            return (TSequencedMap)this.map;
        }

        @Override
        public TSequencedSet<E> reversed() {
            return new SequencedSetFromMap<E>(this.map().reversed());
        }

        @Override
        public void addFirst(E e) {
            this.map().putFirst(e, TBoolean.TRUE);
        }

        @Override
        public void addLast(E e) {
            this.map().putLast(e, TBoolean.TRUE);
        }

        @Override
        public E getFirst() {
            return TLinkedHashMap.checkNotNull(this.map().firstEntry()).getKey();
        }

        @Override
        public E getLast() {
            return TLinkedHashMap.checkNotNull(this.map().lastEntry()).getKey();
        }

        @Override
        public E removeFirst() {
            return TLinkedHashMap.checkNotNull(this.map().pollFirstEntry()).getKey();
        }

        @Override
        public E removeLast() {
            return TLinkedHashMap.checkNotNull(this.map().pollLastEntry()).getKey();
        }
    }
}

