/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio.file.attribute;

import org.teavm.classlib.java.util.concurrent.TTimeUnit;
import org.threeten.bp.Instant;

public class TFileTime
implements Comparable<TFileTime> {
    private final long value;
    private final TTimeUnit unit;
    private Instant instant;

    private TFileTime(long value, TTimeUnit unit, Instant instant) {
        this.value = value;
        this.unit = unit;
    }

    public static TFileTime from(long value, TTimeUnit timeUnit) {
        return new TFileTime(value, timeUnit, null);
    }

    public static TFileTime from(Instant instant) {
        return new TFileTime(instant.toEpochMilli(), TTimeUnit.MILLISECONDS, instant);
    }

    public static TFileTime fromMillis(long value) {
        return new TFileTime(value, TTimeUnit.MILLISECONDS, null);
    }

    public long toMillis() {
        return this.unit.toMillis(this.value);
    }

    public long to(TTimeUnit target) {
        return target.convert(this.value, this.unit);
    }

    public Instant toInstant() {
        if (this.instant == null) {
            this.instant = Instant.ofEpochMilli(this.toMillis());
        }
        return this.instant;
    }

    @Override
    public int compareTo(TFileTime o) {
        return this.toInstant().compareTo(o.toInstant());
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof TFileTime && this.toInstant().equals(((TFileTime)obj).toInstant());
    }

    public int hashCode() {
        return this.toInstant().hashCode();
    }
}

