/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TByteBufferImpl;
import org.teavm.classlib.java.nio.TDoubleBuffer;
import org.teavm.classlib.java.nio.TDoubleBufferImpl;

abstract class TDoubleBufferOverByteBuffer
extends TDoubleBufferImpl {
    TByteBufferImpl byteBuffer;
    private boolean readOnly;
    int start;
    private int capacity;

    TDoubleBufferOverByteBuffer(int start, int capacity, TByteBufferImpl byteBuffer, int position, int limit, boolean readOnly) {
        super(position, limit);
        this.start = start;
        this.capacity = capacity;
        this.byteBuffer = byteBuffer;
        this.readOnly = readOnly;
    }

    @Override
    boolean isArrayPresent() {
        return false;
    }

    @Override
    double[] getArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    int getArrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    boolean readOnly() {
        return this.readOnly;
    }

    @Override
    void getImpl(int index, double[] dst, int offset, int length) {
        while (length-- > 0) {
            dst[offset++] = this.getElement(index++);
        }
    }

    @Override
    void putImpl(int index, double[] src, int offset, int length) {
        while (length-- > 0) {
            this.putElement(index++, src[offset++]);
        }
    }

    @Override
    void putImpl(int index, TDoubleBuffer src, int offset, int length) {
        if (src instanceof TDoubleBufferOverByteBuffer && src.order() == this.order()) {
            TDoubleBufferOverByteBuffer srcImpl = (TDoubleBufferOverByteBuffer)src;
            System.arraycopy(srcImpl.byteBuffer.array, srcImpl.start + index * 8, this.byteBuffer.array, this.start + offset * 8, length * 8);
        } else {
            while (length-- > 0) {
                this.putElement(index++, src.getElement(offset++));
            }
        }
    }

    @Override
    int capacityImpl() {
        return this.capacity;
    }
}

