/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import org.teavm.classlib.java.util.TAbstractSet;
import org.teavm.classlib.java.util.TCollection;
import org.teavm.classlib.java.util.TCollections;
import org.teavm.classlib.java.util.TComparator;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TNoSuchElementException;
import org.teavm.classlib.java.util.TSortedSet;

class TReversedSortedSet<E>
extends TAbstractSet<E>
implements TSortedSet<E> {
    private final TSortedSet<E> base;

    TReversedSortedSet(TSortedSet<E> base) {
        this.base = base;
    }

    @Override
    public TIterator<E> iterator() {
        return new DescendingSortedSetIterator<E>(this.base);
    }

    @Override
    public boolean add(E e) {
        this.base.add(e);
        return true;
    }

    @Override
    public boolean addAll(TCollection<? extends E> c) {
        return this.base.addAll(c);
    }

    @Override
    public void clear() {
        this.base.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.base.contains(o);
    }

    @Override
    public boolean containsAll(TCollection<?> c) {
        return this.base.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.base.isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        return this.base.remove(o);
    }

    @Override
    public E removeFirst() {
        return this.base.removeLast();
    }

    @Override
    public E removeLast() {
        return this.base.removeFirst();
    }

    @Override
    public boolean removeAll(TCollection<?> c) {
        return this.base.removeAll(c);
    }

    @Override
    public boolean retainAll(TCollection<?> c) {
        return this.base.retainAll(c);
    }

    @Override
    public int size() {
        return this.base.size();
    }

    @Override
    public TComparator<? super E> comparator() {
        TComparator<E> comp = this.base.comparator();
        return comp != null ? comp.reversed() : TCollections.reverseOrder();
    }

    @Override
    public E first() {
        return this.base.last();
    }

    @Override
    public E last() {
        return this.base.first();
    }

    @Override
    public E getFirst() {
        return this.base.last();
    }

    @Override
    public E getLast() {
        return this.base.first();
    }

    @Override
    public TSortedSet<E> headSet(E to) {
        return new DescSubset<Object>((TSortedSet<Object>)this.base, null, to);
    }

    @Override
    public TSortedSet<E> subSet(E from, E to) {
        return new DescSubset<E>(this.base, from, to);
    }

    @Override
    public TSortedSet<E> tailSet(E from) {
        return new DescSubset<Object>((TSortedSet<Object>)this.base, from, null);
    }

    private static class DescendingSortedSetIterator<E>
    implements TIterator<E> {
        private final TSortedSet<E> base;
        private TSortedSet<E> remaining;
        private E current;

        private DescendingSortedSetIterator(TSortedSet<E> base) {
            this.base = base;
            this.remaining = base;
        }

        @Override
        public boolean hasNext() {
            return !this.remaining.isEmpty();
        }

        @Override
        public E next() {
            if (this.remaining.isEmpty()) {
                throw new TNoSuchElementException();
            }
            this.current = this.remaining.last();
            this.remaining = this.base.headSet(this.current);
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            this.base.remove(this.current);
            this.current = null;
        }
    }

    static class DescSubset<E>
    extends TAbstractSet<E>
    implements TSortedSet<E> {
        final TSortedSet<E> base;
        final E head;
        final E tail;
        private final TComparator<E> reversed;

        DescSubset(TSortedSet<E> base, E head, E tail) {
            this.base = base;
            this.head = head;
            this.tail = tail;
            this.reversed = TCollections.reverseOrder(base.comparator());
        }

        private boolean aboveHeadInc(E e) {
            return this.head == null || this.reversed.compare(e, this.head) >= 0;
        }

        private boolean belowTailExc(E e) {
            return this.tail == null || this.reversed.compare(e, this.tail) < 0;
        }

        @Override
        public TIterator<E> iterator() {
            return new TIterator<E>(){
                private final TIterator<E> it;
                private E current;
                private boolean finished;
                {
                    this.it = new DescendingSortedSetIterator(base);
                }

                @Override
                public boolean hasNext() {
                    if (this.finished) {
                        return false;
                    }
                    if (this.current != null) {
                        return true;
                    }
                    while (this.it.hasNext()) {
                        Object e = this.it.next();
                        if (!this.aboveHeadInc(e)) continue;
                        if (!this.belowTailExc(e)) {
                            this.finished = true;
                            return false;
                        }
                        this.current = e;
                        return true;
                    }
                    return false;
                }

                @Override
                public E next() {
                    if (this.hasNext()) {
                        Object e = this.current;
                        this.current = null;
                        return e;
                    }
                    throw new TNoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean add(E e) {
            if (this.aboveHeadInc(e) && this.belowTailExc(e)) {
                return this.base.add(e);
            }
            throw new IllegalArgumentException();
        }

        @Override
        public boolean remove(Object o) {
            Object e = o;
            if (this.aboveHeadInc(e) && this.belowTailExc(e)) {
                return this.base.remove(o);
            }
            return false;
        }

        @Override
        public int size() {
            int size = 0;
            TIterator<E> it = this.iterator();
            while (it.hasNext()) {
                ++size;
                it.next();
            }
            return size;
        }

        @Override
        public TComparator<? super E> comparator() {
            TComparator<E> comp = this.base.comparator();
            return comp != null ? comp.reversed() : TCollections.reverseOrder();
        }

        @Override
        public E first() {
            return this.iterator().next();
        }

        @Override
        public E last() {
            TIterator<E> it = this.iterator();
            if (!it.hasNext()) {
                throw new TNoSuchElementException();
            }
            E last = it.next();
            while (it.hasNext()) {
                last = it.next();
            }
            return last;
        }

        @Override
        public TSortedSet<E> subSet(E from, E to) {
            if (this.aboveHeadInc(from) && this.belowTailExc(from) && this.aboveHeadInc(to) && this.belowTailExc(to) && this.reversed.compare(from, to) <= 0) {
                return new DescSubset<E>(this.base, from, to);
            }
            throw new IllegalArgumentException();
        }

        @Override
        public TSortedSet<E> headSet(E to) {
            if (this.aboveHeadInc(to) && this.belowTailExc(to)) {
                return new DescSubset<E>(this.base, this.head, to);
            }
            throw new IllegalArgumentException();
        }

        @Override
        public TSortedSet<E> tailSet(E from) {
            if (this.aboveHeadInc(from) && this.belowTailExc(from)) {
                return new DescSubset<Object>((TSortedSet<Object>)this.base, null, this.tail);
            }
            throw new IllegalArgumentException();
        }
    }
}

