/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.io;

import java.io.IOException;
import java.io.Writer;

public class TCharArrayWriter
extends Writer {
    protected char[] buf;
    protected int count;

    public TCharArrayWriter() {
        this.buf = new char[32];
        this.lock = this.buf;
    }

    public TCharArrayWriter(int initialSize) {
        if (initialSize < 0) {
            throw new IllegalArgumentException();
        }
        this.buf = new char[initialSize];
        this.lock = this.buf;
    }

    @Override
    public void close() {
    }

    private void expand(int i) {
        if (this.count + i <= this.buf.length) {
            return;
        }
        int newLen = Math.max(2 * this.buf.length, this.count + i);
        char[] newbuf = new char[newLen];
        System.arraycopy(this.buf, 0, newbuf, 0, this.count);
        this.buf = newbuf;
    }

    @Override
    public void flush() {
    }

    public void reset() {
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public char[] toCharArray() {
        char[] result = new char[this.count];
        System.arraycopy(this.buf, 0, result, 0, this.count);
        return result;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    @Override
    public void write(char[] c, int offset, int len) {
        if (offset < 0 || offset > c.length || len < 0 || len > c.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        this.expand(len);
        System.arraycopy(c, offset, this.buf, this.count, len);
        this.count += len;
    }

    @Override
    public void write(int oneChar) {
        this.expand(1);
        this.buf[this.count++] = (char)oneChar;
    }

    @Override
    public void write(String str, int offset, int len) {
        if (str == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset > str.length() || len < 0 || len > str.length() - offset) {
            throw new StringIndexOutOfBoundsException();
        }
        this.expand(len);
        str.getChars(offset, offset + len, this.buf, this.count);
        this.count += len;
    }

    public void writeTo(Writer out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    @Override
    public TCharArrayWriter append(char c) {
        this.write(c);
        return this;
    }

    @Override
    public TCharArrayWriter append(CharSequence csq) {
        if (null == csq) {
            this.append("NULL", 0, 4);
        } else {
            this.append(csq, 0, csq.length());
        }
        return this;
    }

    @Override
    public TCharArrayWriter append(CharSequence csq, int start, int end) {
        if (null == csq) {
            csq = "NULL";
        }
        String output = csq.subSequence(start, end).toString();
        this.write(output, 0, output.length());
        return this;
    }
}

