/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import java.io.IOException;
import org.teavm.codegen.SourceWriter;
import org.teavm.dependency.DependencyChecker;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.DependencyPlugin;
import org.teavm.dependency.FieldDependency;
import org.teavm.dependency.MethodDependency;
import org.teavm.javascript.ni.Generator;
import org.teavm.javascript.ni.GeneratorContext;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodReference;

public class SystemNativeGenerator
implements Generator,
DependencyPlugin {
    public void generate(GeneratorContext context, SourceWriter writer, MethodReference methodRef) throws IOException {
        switch (methodRef.getName()) {
            case "doArrayCopy": {
                this.generateArrayCopy(context, writer);
                break;
            }
            case "currentTimeMillis": {
                this.generateCurrentTimeMillis(writer);
                break;
            }
            case "setOut": {
                writer.appendClass("java.lang.System").append('.').appendField(new FieldReference("java.lang.System", "out")).ws().append('=').ws().append(context.getParameterName(1)).append(";").softNewLine();
                break;
            }
            case "setErr": {
                writer.appendClass("java.lang.System").append('.').appendField(new FieldReference("java.lang.System", "err")).ws().append('=').ws().append(context.getParameterName(1)).append(";").softNewLine();
                break;
            }
            case "identityHashCode": {
                writer.append("return ").append(context.getParameterName(1)).append(".$id;").softNewLine();
            }
        }
    }

    public void methodAchieved(DependencyChecker checker, MethodDependency method) {
        switch (method.getReference().getName()) {
            case "doArrayCopy": {
                this.achieveArrayCopy(method);
                break;
            }
            case "setOut": {
                this.achieveSetOut(checker, method);
                break;
            }
            case "setErr": {
                this.achieveSetErr(checker, method);
            }
        }
    }

    private void generateArrayCopy(GeneratorContext context, SourceWriter writer) throws IOException {
        String src = context.getParameterName(1);
        String srcPos = context.getParameterName(2);
        String dest = context.getParameterName(3);
        String destPos = context.getParameterName(4);
        String length = context.getParameterName(5);
        writer.append("for (var i = 0; i < " + length + "; i = (i + 1) | 0) {").indent().softNewLine();
        writer.append(dest + ".data[" + srcPos + "++] = " + src + ".data[" + destPos + "++];").softNewLine();
        writer.outdent().append("}").softNewLine();
    }

    private void generateCurrentTimeMillis(SourceWriter writer) throws IOException {
        writer.append("return Long_fromNumber(new Date().getTime());").softNewLine();
    }

    private void achieveArrayCopy(MethodDependency method) {
        DependencyNode src = method.getVariable(1);
        DependencyNode dest = method.getVariable(3);
        src.getArrayItem().connect(dest.getArrayItem());
    }

    private void achieveSetErr(DependencyChecker checker, MethodDependency method) {
        FieldDependency fieldDep = checker.linkField(new FieldReference("java.lang.System", "err"), method.getStack());
        method.getVariable(1).connect(fieldDep.getValue());
    }

    private void achieveSetOut(DependencyChecker checker, MethodDependency method) {
        FieldDependency fieldDep = checker.linkField(new FieldReference("java.lang.System", "out"), method.getStack());
        method.getVariable(1).connect(fieldDep.getValue());
    }
}

