/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.unicode;

import java.util.Arrays;

public class UnicodeHelper {
    static char hexDigit(int value) {
        return value < 10 ? (char)(48 + value) : (char)(65 + value);
    }

    static int valueOfHexDigit(char digit) {
        return digit <= '9' ? digit - 48 : digit - 65 + 10;
    }

    public static String encodeIntByte(int[] data) {
        char[] chars = new char[data.length / 2 * 5];
        int j = 0;
        int i = 0;
        while (i < data.length) {
            int val = data[i++];
            int shift = 32;
            for (int k = 0; k < 4; ++k) {
                chars[j++] = (char)(122 + (val >> (shift -= 8) & 0xFF));
            }
            chars[j++] = (char)(122 + (data[i++] & 0xFF));
        }
        return new String(chars);
    }

    public static int[] decodeIntByte(String text) {
        int[] data = new int[2 * (text.length() / 5)];
        int j = 0;
        int i = 0;
        while (i < data.length) {
            int val = 0;
            for (int k = 0; k < 4; ++k) {
                val = val << 8 | text.charAt(j++) - 122;
            }
            data[i++] = val;
            data[i++] = text.charAt(j++) - 122;
        }
        return data;
    }

    public static char encodeByte(byte b) {
        if (b < 2) {
            return (char)(b + 32);
        }
        if (b < 59) {
            return (char)(b + 32 + 1);
        }
        return (char)(b + 32 + 2);
    }

    public static byte decodeByte(char c) {
        if (c > '\\') {
            return (byte)(c - 32 - 2);
        }
        if (c > '\"') {
            return (byte)(c - 32 - 1);
        }
        return (byte)(c - 32);
    }

    public static String compressRle(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < bytes.length) {
            byte b = bytes[i];
            if (i < bytes.length - 1 && b == bytes[i + 1]) {
                int count;
                for (count = 0; count < 16384 && i < bytes.length && bytes[i + count] == b; ++count) {
                }
                i += count;
                if (count < 80) {
                    sb.append(UnicodeHelper.encodeByte((byte)(b + 32)));
                    sb.append(UnicodeHelper.encodeByte((byte)count));
                    continue;
                }
                sb.append(UnicodeHelper.encodeByte((byte)64));
                sb.append(UnicodeHelper.encodeByte(b));
                for (int j = 0; j < 3; ++j) {
                    sb.append(UnicodeHelper.encodeByte((byte)(count & 0x3F)));
                    count /= 64;
                }
                continue;
            }
            sb.append(UnicodeHelper.encodeByte(bytes[i++]));
        }
        return sb.toString();
    }

    public static Range[] extractRle(String encoded) {
        Range[] ranges = new Range[16384];
        byte[] buffer = new byte[16384];
        int index = 0;
        int rangeIndex = 0;
        int codePoint = 0;
        for (int i = 0; i < encoded.length(); ++i) {
            int count;
            byte b = UnicodeHelper.decodeByte(encoded.charAt(i));
            if (b == 64) {
                b = UnicodeHelper.decodeByte(encoded.charAt(++i));
                count = 0;
                int pos = 1;
                for (int j = 0; j < 3; ++j) {
                    byte digit = UnicodeHelper.decodeByte(encoded.charAt(++i));
                    count |= pos * digit;
                    pos *= 64;
                }
            } else if (b >= 32) {
                b = (byte)(b - 32);
                count = UnicodeHelper.decodeByte(encoded.charAt(++i));
            } else {
                count = 1;
            }
            if (b != 0 || count < 128) {
                if (index + count >= buffer.length) {
                    ranges[rangeIndex++] = new Range(codePoint, codePoint + index, Arrays.copyOf(buffer, index));
                    codePoint += index + count;
                    index = 0;
                }
                while (count-- > 0) {
                    buffer[index++] = b;
                }
                continue;
            }
            if (index > 0) {
                ranges[rangeIndex++] = new Range(codePoint, codePoint + index, Arrays.copyOf(buffer, index));
            }
            codePoint += index + count;
            index = 0;
        }
        return Arrays.copyOf(ranges, rangeIndex);
    }

    public static class Range {
        public final int start;
        public final int end;
        public final byte[] data;

        public Range(int start, int end, byte[] data) {
            this.start = start;
            this.end = end;
            this.data = data;
        }
    }
}

