/*
 * Decompiled with CFR 0.152.
 */
package org.talend.runtime.documentation.component.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.talend.sdk.component.api.configuration.Option;
import org.talend.sdk.component.api.configuration.action.Proposable;
import org.talend.sdk.component.api.configuration.ui.layout.GridLayout;
import org.talend.sdk.component.api.configuration.ui.layout.GridLayouts;
import org.talend.sdk.component.api.configuration.ui.widget.Structure;
import org.talend.sdk.component.api.meta.Documentation;

@GridLayouts(value={@GridLayout(value={@GridLayout.Row(value={"tableName"})}), @GridLayout(names={"Advanced"}, value={@GridLayout.Row(value={"fields"})})})
@Documentation(value="Table Configuration")
public class CommonConfig
implements Serializable {
    public static final String PROPOSABLE_GET_TABLE_FIELDS = "GetTableFields";
    @Option
    @Documentation(value="The name of the table to be read")
    private Tables tableName = Tables.incident;
    @Option
    @Structure(discoverSchema="guessTableSchema", type=Structure.Type.OUT)
    @Proposable(value="GetTableFields")
    @Documentation(value="List of field names to return in the response.")
    private List<String> fields = new ArrayList<String>();

    public String getFieldsCommaSeparated() {
        if (this.getFields() == null || this.getFields().isEmpty()) {
            return null;
        }
        return this.getFields().stream().collect(Collectors.joining(","));
    }

    public Tables getTableName() {
        return this.tableName;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public void setTableName(Tables tableName) {
        this.tableName = tableName;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommonConfig)) {
            return false;
        }
        CommonConfig other = (CommonConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Tables this$tableName = this.getTableName();
        Tables other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !((Object)((Object)this$tableName)).equals((Object)other$tableName)) {
            return false;
        }
        List<String> this$fields = this.getFields();
        List<String> other$fields = other.getFields();
        return !(this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommonConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Tables $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : ((Object)((Object)$tableName)).hashCode());
        List<String> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        return result;
    }

    public String toString() {
        return "CommonConfig(tableName=" + (Object)((Object)this.getTableName()) + ", fields=" + this.getFields() + ")";
    }

    public CommonConfig() {
    }

    public CommonConfig(Tables tableName, List<String> fields) {
        this.tableName = tableName;
        this.fields = fields;
    }

    public static enum Tables {
        incident,
        problem,
        change_request,
        sc_request,
        sc_cat_item;

    }
}

