/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.configuration;

import java.lang.annotation.Annotation;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.api.meta.Documentation;

@ApplicationScoped
public class ComponentServerConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ComponentServerConfiguration.class);
    @Inject
    @Documentation(value="If set it will replace any message for exceptions. Set to `false` to use the actual exception message.")
    @ConfigProperty(name="talend.component.server.jaxrs.exceptionhandler.defaultMessage", defaultValue="false")
    private String defaultExceptionMessage;
    @Inject
    @Documentation(value="The local maven repository used to locate components and their dependencies")
    @ConfigProperty(name="talend.component.server.maven.repository")
    private Optional<String> mavenRepository;
    @Inject
    @Documentation(value="A comma separated list of gav to locate the components")
    @ConfigProperty(name="talend.component.server.component.coordinates")
    private Optional<String> componentCoordinates;
    @Inject
    @Documentation(value="A property file where the value is a gav of a component to register (complementary with `coordinates`). Note that the path can end up with `*` or `*.properties` to take into account all properties in a folder.")
    @ConfigProperty(name="talend.component.server.component.registry")
    private Optional<String> componentRegistry;
    @Inject
    @Documentation(value="Should the /documentation endpoint be activated. Note that when called on localhost the doc is always available.")
    @ConfigProperty(name="talend.component.server.documentation.active", defaultValue="true")
    private Boolean supportsDocumentation;
    @Inject
    @Documentation(value="How to validate a connection. Accepted values: securityNoopHandler.")
    @ConfigProperty(name="talend.component.server.security.connection.handler", defaultValue="securityNoopHandler")
    private String securityConnectionHandler;
    @Inject
    @Documentation(value="How to validate a command/request. Accepted values: securityNoopHandler.")
    @ConfigProperty(name="talend.component.server.security.command.handler", defaultValue="securityNoopHandler")
    private String securityCommandHandler;
    @Inject
    @Documentation(value="Should the component extensions add required dependencies.")
    @ConfigProperty(name="talend.component.server.component.extend.dependencies", defaultValue="true")
    private Boolean addExtensionDependencies;
    @Inject
    @Documentation(value="A component translation repository. This is where you put your documentation translations. Their name must follow the pattern `documentation_${container-id}_language.adoc` where `${container-id}` is the component jar name (without the extension and version, generally the artifactId).")
    @ConfigProperty(name="talend.component.server.component.documentation.translations", defaultValue="${home}/documentations")
    private String documentationI18nTranslations;
    @Inject
    @Documentation(value="Should the /api/v1/environment endpoint be activated. It shows some internal versions and git commit which are not always desirable over the wire.")
    @ConfigProperty(name="talend.component.server.environment.active", defaultValue="true")
    private Boolean supportsEnvironment;
    @Inject
    @Documentation(value="Accepted tokens in Authorization header for remote calls to secured endpoints (/api/v1/environment or /documentation).")
    @ConfigProperty(name="talend.component.server.filter.secured.tokens", defaultValue="-")
    private String securedEndpointsTokens;
    @Inject
    @Documentation(value="A folder available for the server - don't forget to mount it in docker if you are using the image - which accepts subfolders named as component plugin id (generally the artifactId or jar name without the version, ex: jdbc). Each family folder can contain:\n\n- a `user-configuration.properties` file which will be merged with component configuration system (see services). This properties file enables the function `userJar(xxxx)` to replace the jar named `xxxx` by its virtual gav (`groupId:artifactId:version`),\n- a list of jars which will be merged with component family classpath\n")
    @ConfigProperty(name="talend.component.server.user.extensions.location")
    private Optional<String> userExtensions;
    @Inject
    @Documentation(value="Should the implicit artifacts be provisionned to a m2. If set to `auto` it tries to detect if there is a m2 to provision - recommended, if set to `skip` it is ignored, else it uses the value as a m2 path.")
    @ConfigProperty(name="talend.component.server.user.extensions.provisioning.location", defaultValue="auto")
    private String userExtensionsAutoM2Provisioning;
    @Inject
    @Documentation(value="Timeout for extension initialization at startup, since it ensures the startup wait extensions are ready and loaded it allows to control the latency it implies.")
    @ConfigProperty(name="talend.component.server.component.extension.startup.timeout", defaultValue="180000")
    private Long extensionsStartupTimeout;
    @Inject
    @Documentation(value="If you deploy some extension, where they can create their dependencies if needed.")
    @ConfigProperty(name="talend.component.server.component.extension.maven.repository")
    private Optional<String> extensionMavenRepository;
    @Inject
    @Documentation(value="Should the all requests/responses be logged (debug purposes - only work when running with CXF).")
    @ConfigProperty(name="talend.component.server.request.log", defaultValue="false")
    private Boolean logRequests;
    @Inject
    @Documentation(value="Maximum items a cache can store, used for index endpoints.")
    @ConfigProperty(name="talend.component.server.cache.maxSize", defaultValue="1000")
    private Integer maxCacheSize;
    @Inject
    @Documentation(value="Should the lastUpdated timestamp value of `/environment` endpoint be updated with server start time.")
    @ConfigProperty(name="talend.component.server.lastUpdated.useStartTime", defaultValue="false")
    private Boolean changeLastUpdatedAtStartup;

    @PostConstruct
    private void init() {
        if (this.logRequests != null && this.logRequests.booleanValue()) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> feature = loader.loadClass("org.apache.cxf.feature.LoggingFeature");
                Class<?> bus = loader.loadClass("org.apache.cxf.Bus");
                Object instance = feature.getConstructor(new Class[0]).newInstance(new Object[0]);
                Object busInstance = CDI.current().select(bus, new Annotation[0]).get();
                feature.getMethod("initialize", bus).invoke(instance, busInstance);
                log.info("Activated debug mode - will log requests/responses");
            }
            catch (Exception e) {
                log.warn("Can't honor log request configuration, skipping ({})", (Object)e.getMessage());
            }
        }
    }

    public String getDefaultExceptionMessage() {
        return this.defaultExceptionMessage;
    }

    public Optional<String> getMavenRepository() {
        return this.mavenRepository;
    }

    public Optional<String> getComponentCoordinates() {
        return this.componentCoordinates;
    }

    public Optional<String> getComponentRegistry() {
        return this.componentRegistry;
    }

    public Boolean getSupportsDocumentation() {
        return this.supportsDocumentation;
    }

    public String getSecurityConnectionHandler() {
        return this.securityConnectionHandler;
    }

    public String getSecurityCommandHandler() {
        return this.securityCommandHandler;
    }

    public Boolean getAddExtensionDependencies() {
        return this.addExtensionDependencies;
    }

    public String getDocumentationI18nTranslations() {
        return this.documentationI18nTranslations;
    }

    public Boolean getSupportsEnvironment() {
        return this.supportsEnvironment;
    }

    public String getSecuredEndpointsTokens() {
        return this.securedEndpointsTokens;
    }

    public Optional<String> getUserExtensions() {
        return this.userExtensions;
    }

    public String getUserExtensionsAutoM2Provisioning() {
        return this.userExtensionsAutoM2Provisioning;
    }

    public Long getExtensionsStartupTimeout() {
        return this.extensionsStartupTimeout;
    }

    public Optional<String> getExtensionMavenRepository() {
        return this.extensionMavenRepository;
    }

    public Boolean getLogRequests() {
        return this.logRequests;
    }

    public Integer getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public Boolean getChangeLastUpdatedAtStartup() {
        return this.changeLastUpdatedAtStartup;
    }
}

