/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.serialization;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import org.structr.common.SecurityContext;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.rest.serialization.RestWriter;

public class StructrJsonWriter
implements RestWriter {
    private SecurityContext securityContext = null;
    private JsonWriter writer = null;

    public StructrJsonWriter(SecurityContext securityContext, Writer writer) {
        this.securityContext = securityContext;
        this.writer = new JsonWriter(writer);
        this.writer.setLenient(Boolean.parseBoolean(StructrApp.getConfigurationValue((String)"json.lenient", (String)"false")));
    }

    @Override
    public void setIndent(String indent) {
        this.writer.setIndent(indent);
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    @Override
    public RestWriter beginDocument(String baseUrl, String propertyView) throws IOException {
        return this;
    }

    @Override
    public RestWriter endDocument() throws IOException {
        return this;
    }

    @Override
    public RestWriter beginArray() throws IOException {
        this.writer.beginArray();
        return this;
    }

    @Override
    public RestWriter endArray() throws IOException {
        this.writer.endArray();
        return this;
    }

    @Override
    public RestWriter beginObject() throws IOException {
        return this.beginObject(null);
    }

    @Override
    public RestWriter beginObject(GraphObject graphObject) throws IOException {
        this.writer.beginObject();
        return this;
    }

    @Override
    public RestWriter endObject() throws IOException {
        return this.endObject(null);
    }

    @Override
    public RestWriter endObject(GraphObject graphObject) throws IOException {
        this.writer.endObject();
        return this;
    }

    @Override
    public RestWriter name(String name) throws IOException {
        this.writer.name(name);
        return this;
    }

    @Override
    public RestWriter value(String value) throws IOException {
        this.writer.value(value);
        return this;
    }

    @Override
    public RestWriter nullValue() throws IOException {
        this.writer.nullValue();
        return this;
    }

    @Override
    public RestWriter value(boolean value) throws IOException {
        this.writer.value(value);
        return this;
    }

    @Override
    public RestWriter value(double value) throws IOException {
        this.writer.value(value);
        return this;
    }

    @Override
    public RestWriter value(long value) throws IOException {
        this.writer.value(value);
        return this;
    }

    @Override
    public RestWriter value(Number value) throws IOException {
        this.writer.value(value);
        return this;
    }
}

