/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.resource;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.Result;
import org.structr.core.graph.search.SearchCommand;
import org.structr.core.property.PropertyKey;
import org.structr.rest.RestMethodResult;
import org.structr.rest.exception.IllegalMethodException;
import org.structr.rest.exception.NotFoundException;
import org.structr.rest.resource.FilterableResource;
import org.structr.rest.resource.RelationshipResource;
import org.structr.rest.resource.Resource;
import org.structr.rest.resource.StaticRelationshipResource;
import org.structr.rest.resource.TypeResource;
import org.structr.rest.resource.UuidResource;
import org.structr.schema.SchemaHelper;

public class TypedIdResource
extends FilterableResource {
    protected TypeResource typeResource = null;
    protected UuidResource idResource = null;

    protected TypedIdResource(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public TypedIdResource(SecurityContext securityContext, UuidResource idResource, TypeResource typeResource) {
        this.securityContext = securityContext;
        this.typeResource = typeResource;
        this.idResource = idResource;
    }

    @Override
    public boolean checkAndConfigure(String part, SecurityContext securityContext, HttpServletRequest request) throws FrameworkException {
        return false;
    }

    @Override
    public Result doGet(PropertyKey sortKey, boolean sortDescending, int pageSize, int page, String offsetId) throws FrameworkException {
        return new Result(this.getEntity(), this.isPrimitiveArray());
    }

    @Override
    public RestMethodResult doPost(Map<String, Object> propertySet) throws FrameworkException {
        throw new IllegalMethodException("POST not allowed on " + this.typeResource.getRawType() + " element resource");
    }

    @Override
    public Class getEntityClass() {
        return this.typeResource.getEntityClass();
    }

    public TypeResource getTypeResource() {
        return this.typeResource;
    }

    public UuidResource getIdResource() {
        return this.idResource;
    }

    @Override
    public Resource tryCombineWith(Resource next) throws FrameworkException {
        if (next instanceof TypeResource) {
            return new StaticRelationshipResource(this.securityContext, this, (TypeResource)next);
        }
        if (next instanceof RelationshipResource) {
            ((RelationshipResource)next).wrapResource(this);
            return next;
        }
        return super.tryCombineWith(next);
    }

    @Override
    public String getUriPart() {
        return this.typeResource.getUriPart().concat("/").concat(this.idResource.getUriPart());
    }

    @Override
    public String getResourceSignature() {
        return this.typeResource.getResourceSignature();
    }

    @Override
    public boolean isCollectionResource() {
        return false;
    }

    public GraphObject getEntity() throws FrameworkException {
        GraphObject entity = this.idResource.getEntity();
        if (entity != null) {
            String type = SchemaHelper.normalizeEntityName((String)this.typeResource.getRawType());
            String entityType = entity.getClass().getSimpleName();
            if (SearchCommand.getAllSubtypesAsStringSet((String)type).contains(entityType)) {
                return entity;
            }
        }
        throw new NotFoundException("Entity with ID " + this.idResource.getUuid() + " not found");
    }
}

