/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.resource;

import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.Result;
import org.structr.core.entity.Principal;
import org.structr.core.property.PropertyKey;
import org.structr.rest.RestMethodResult;
import org.structr.rest.exception.IllegalPathException;
import org.structr.rest.exception.NotAllowedException;
import org.structr.rest.resource.TypeResource;
import org.structr.rest.resource.TypedIdResource;
import org.structr.rest.resource.UuidResource;

public class MeResource
extends TypedIdResource {
    private static final Logger logger = Logger.getLogger(MeResource.class.getName());

    public MeResource() {
        super(null);
    }

    public MeResource(SecurityContext securityContext) {
        super(securityContext);
    }

    @Override
    public boolean checkAndConfigure(String part, SecurityContext securityContext, HttpServletRequest request) throws FrameworkException {
        this.securityContext = securityContext;
        if ("me".equalsIgnoreCase(part)) {
            this.typeResource = new TypeResource();
            this.typeResource.setSecurityContext(securityContext);
            this.typeResource.checkAndConfigure("user", securityContext, request);
            Principal user = securityContext.getUser(true);
            if (user != null) {
                this.idResource = new UuidResource();
                this.idResource.setSecurityContext(securityContext);
                this.idResource.checkAndConfigure((String)user.getProperty((PropertyKey)GraphObject.id), securityContext, request);
            }
        }
        return true;
    }

    @Override
    public Result doGet(PropertyKey sortKey, boolean sortDescending, int pageSize, int page, String offsetId) throws FrameworkException {
        Principal user = this.securityContext.getUser(true);
        if (user != null) {
            LinkedList<Principal> resultList = new LinkedList<Principal>();
            resultList.add(user);
            return new Result(resultList, null, this.isCollectionResource(), this.isPrimitiveArray());
        }
        throw new NotAllowedException("No user");
    }

    @Override
    public RestMethodResult doPost(Map<String, Object> propertySet) throws FrameworkException {
        if (this.typeResource != null) {
            return this.typeResource.doPost(propertySet);
        }
        throw new IllegalPathException(this.getResourceSignature() + " can only be applied to a non-empty resource");
    }

    @Override
    public String getUriPart() {
        return "me";
    }
}

