/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.resource;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.structr.agent.Task;
import org.structr.api.service.Command;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.Result;
import org.structr.core.graph.BulkChangeNodePropertyKeyCommand;
import org.structr.core.graph.BulkCopyRelationshipPropertyCommand;
import org.structr.core.graph.BulkCreateLabelsCommand;
import org.structr.core.graph.BulkDeleteSoftDeletedNodesCommand;
import org.structr.core.graph.BulkFixNodePropertiesCommand;
import org.structr.core.graph.BulkRebuildIndexCommand;
import org.structr.core.graph.BulkSetNodePropertiesCommand;
import org.structr.core.graph.BulkSetRelationshipPropertiesCommand;
import org.structr.core.graph.BulkSetUuidCommand;
import org.structr.core.graph.ClearDatabase;
import org.structr.core.graph.FlushCachesCommand;
import org.structr.core.graph.SyncCommand;
import org.structr.core.property.PropertyKey;
import org.structr.rest.RestMethodResult;
import org.structr.rest.exception.NotAllowedException;
import org.structr.rest.maintenance.SnapshotCommand;
import org.structr.rest.resource.Resource;
import org.structr.schema.SchemaHelper;
import org.structr.schema.importer.GraphGistImporter;
import org.structr.schema.importer.RDFImporter;
import org.structr.schema.importer.SchemaJsonImporter;

public class MaintenanceParameterResource
extends Resource {
    private static final Map<String, Class> maintenanceCommandMap = new LinkedHashMap<String, Class>();
    private String uriPart = null;

    @Override
    public boolean checkAndConfigure(String part, SecurityContext securityContext, HttpServletRequest request) {
        this.securityContext = securityContext;
        if (maintenanceCommandMap.containsKey(part)) {
            this.uriPart = part;
            return true;
        }
        return false;
    }

    @Override
    public Result doGet(PropertyKey sortKey, boolean sortDescending, int pageSize, int page, String offsetId) throws FrameworkException {
        throw new NotAllowedException("GET not allowed, use POST to run maintenance commands");
    }

    @Override
    public RestMethodResult doPut(Map<String, Object> propertySet) throws FrameworkException {
        throw new NotAllowedException("PUT not allowed, use POST to run maintenance commands");
    }

    @Override
    public RestMethodResult doPost(Map<String, Object> propertySet) throws FrameworkException {
        throw new NotAllowedException("POST not allowed here, this should not happen. Please report the URL that led to this error message to team@structr.com. Thank you!");
    }

    @Override
    public Resource tryCombineWith(Resource next) throws FrameworkException {
        return null;
    }

    public Class getEntityClass() {
        return null;
    }

    public Class getMaintenanceCommand() {
        return maintenanceCommandMap.get(this.uriPart);
    }

    @Override
    public String getUriPart() {
        return this.uriPart;
    }

    @Override
    public boolean isCollectionResource() {
        return false;
    }

    @Override
    public String getResourceSignature() {
        return SchemaHelper.normalizeEntityName((String)this.getUriPart());
    }

    public static void registerMaintenanceTask(String key, Class<? extends Task> task) {
        if (maintenanceCommandMap.containsKey(key)) {
            throw new IllegalStateException("Maintenance command for key " + key + " already registered!");
        }
        maintenanceCommandMap.put(key, task);
    }

    public static void registerMaintenanceCommand(String key, Class<? extends Command> command) {
        if (maintenanceCommandMap.containsKey(key)) {
            throw new IllegalStateException("Maintenance command for key " + key + " already registered!");
        }
        maintenanceCommandMap.put(key, command);
    }

    static {
        maintenanceCommandMap.put("importGist", GraphGistImporter.class);
        maintenanceCommandMap.put("importRdf", RDFImporter.class);
        maintenanceCommandMap.put("importSchemaJson", SchemaJsonImporter.class);
        maintenanceCommandMap.put("rebuildIndex", BulkRebuildIndexCommand.class);
        maintenanceCommandMap.put("rebuildIndexForType", BulkRebuildIndexCommand.class);
        maintenanceCommandMap.put("createLabels", BulkCreateLabelsCommand.class);
        maintenanceCommandMap.put("clearDatabase", ClearDatabase.class);
        maintenanceCommandMap.put("fixNodeProperties", BulkFixNodePropertiesCommand.class);
        maintenanceCommandMap.put("setNodeProperties", BulkSetNodePropertiesCommand.class);
        maintenanceCommandMap.put("changeNodePropertyKey", BulkChangeNodePropertyKeyCommand.class);
        maintenanceCommandMap.put("setRelationshipProperties", BulkSetRelationshipPropertiesCommand.class);
        maintenanceCommandMap.put("copyRelationshipProperties", BulkCopyRelationshipPropertyCommand.class);
        maintenanceCommandMap.put("deleteSoftDeletedNodes", BulkDeleteSoftDeletedNodesCommand.class);
        maintenanceCommandMap.put("setUuid", BulkSetUuidCommand.class);
        maintenanceCommandMap.put("sync", SyncCommand.class);
        maintenanceCommandMap.put("snapshot", SnapshotCommand.class);
        maintenanceCommandMap.put("flushCaches", FlushCachesCommand.class);
    }
}

