/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.resource;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.structr.common.SecurityContext;
import org.structr.common.error.EmptyPropertyToken;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.ErrorToken;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.GraphObjectMap;
import org.structr.core.Result;
import org.structr.core.Services;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.Tx;
import org.structr.core.property.GenericProperty;
import org.structr.core.property.ISO8601DateProperty;
import org.structr.core.property.IntProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.core.property.StringProperty;
import org.structr.rest.RestMethodResult;
import org.structr.rest.exception.IllegalMethodException;
import org.structr.rest.logging.entity.LogEvent;
import org.structr.rest.resource.Resource;

public class LogResource
extends Resource {
    private static final Logger logger = Logger.getLogger(LogResource.class.getName());
    private static final Pattern RangeQueryPattern = Pattern.compile("\\[(.+) TO (.+)\\]");
    private static final String SUBJECTS = "/s/";
    private static final String CORRELATION_SEPARATOR = "::";
    private static final Property<String> subjectProperty = new StringProperty("subject");
    private static final Property<String> objectProperty = new StringProperty("object");
    private static final Property<String> actionProperty = new StringProperty("action");
    private static final Property<String> actionsProperty = new StringProperty("actions");
    private static final Property<String> messageProperty = new StringProperty("message");
    private static final Property<Integer> entryCountProperty = new IntProperty("entryCount");
    private static final Property<Integer> totalProperty = new IntProperty("total");
    private static final ISO8601DateProperty timestampProperty = new ISO8601DateProperty("timestamp");
    private static final ISO8601DateProperty firstEntryProperty = new ISO8601DateProperty("firstEntry");
    private static final ISO8601DateProperty lastEntryProperty = new ISO8601DateProperty("lastEntry");
    private static final Set<String> ReservedRequestParameters = new LinkedHashSet<String>(Arrays.asList("subject", "object", "action", "message", "timestamp", "aggregate", "histogram", "correlate"));
    public static final String LOG_RESOURCE_URI = "log";

    @Override
    public Resource tryCombineWith(Resource next) throws FrameworkException {
        return null;
    }

    @Override
    public boolean checkAndConfigure(String part, SecurityContext securityContext, HttpServletRequest request) throws FrameworkException {
        subjectProperty.setDeclaringClass(LogResource.class);
        objectProperty.setDeclaringClass(LogResource.class);
        actionProperty.setDeclaringClass(LogResource.class);
        messageProperty.setDeclaringClass(LogResource.class);
        timestampProperty.setDeclaringClass(LogResource.class);
        this.securityContext = securityContext;
        this.securityContext.setRequest(request);
        return LOG_RESOURCE_URI.equals(part);
    }

    @Override
    public String getUriPart() {
        return LOG_RESOURCE_URI;
    }

    @Override
    public Class<? extends GraphObject> getEntityClass() {
        return GraphObject.class;
    }

    @Override
    public String getResourceSignature() {
        return "Log";
    }

    @Override
    public boolean isCollectionResource() throws FrameworkException {
        return true;
    }

    @Override
    public Result doGet(PropertyKey sortKey, boolean sortDescending, int pageSize, int page, String offsetId) throws FrameworkException {
        HttpServletRequest request = this.securityContext.getRequest();
        if (request != null) {
            String subjectId = request.getParameter(subjectProperty.jsonName());
            String objectId = request.getParameter(objectProperty.jsonName());
            GraphObjectMap overviewMap = new GraphObjectMap();
            LogState logState = new LogState(request);
            if (StringUtils.isNotEmpty((CharSequence)subjectId) && StringUtils.isNotEmpty((CharSequence)objectId)) {
                this.processData(logState, StructrApp.getInstance((SecurityContext)this.securityContext).nodeQuery(LogEvent.class).and(LogEvent.subjectProperty, (Object)subjectId).and(LogEvent.objectProperty, (Object)objectId).and(LogEvent.actionProperty, (Object)logState.logAction).andRange(LogEvent.timestampProperty, (Object)new Date(logState.beginTimestamp()), (Object)new Date(logState.endTimestamp())).getAsList());
            } else if (StringUtils.isNotEmpty((CharSequence)subjectId) && StringUtils.isEmpty((CharSequence)objectId)) {
                this.processData(logState, StructrApp.getInstance((SecurityContext)this.securityContext).nodeQuery(LogEvent.class).and(LogEvent.subjectProperty, (Object)subjectId).and(LogEvent.actionProperty, (Object)logState.logAction).andRange(LogEvent.timestampProperty, (Object)new Date(logState.beginTimestamp()), (Object)new Date(logState.endTimestamp())).getAsList());
            } else if (StringUtils.isEmpty((CharSequence)subjectId) && StringUtils.isNotEmpty((CharSequence)objectId)) {
                logState.inverse(true);
                this.processData(logState, StructrApp.getInstance((SecurityContext)this.securityContext).nodeQuery(LogEvent.class).and(LogEvent.objectProperty, (Object)objectId).and(LogEvent.actionProperty, (Object)logState.logAction).andRange(LogEvent.timestampProperty, (Object)new Date(logState.beginTimestamp()), (Object)new Date(logState.endTimestamp())).getAsList());
            } else if (logState.doActionQuery()) {
                this.processData(logState);
            } else {
                logState.overview(true);
                this.processData(logState, StructrApp.getInstance((SecurityContext)this.securityContext).nodeQuery(LogEvent.class).getAsList());
            }
            if (logState.overview()) {
                overviewMap.put(actionsProperty, logState.actions());
                overviewMap.put(entryCountProperty, (Object)logState.actionCount());
                overviewMap.put((PropertyKey)firstEntryProperty, (Object)new Date(logState.beginTimestamp()));
                overviewMap.put((PropertyKey)lastEntryProperty, (Object)new Date(logState.endTimestamp()));
                return new Result((GraphObject)overviewMap, false);
            }
            if (logState.doHistogram()) {
                return this.histogram(logState);
            }
            if (logState.doAggregate()) {
                return this.aggregate(logState);
            }
            logState.sortEntries();
            return new Result(this.wrap(logState.entries()), Integer.valueOf(logState.size()), true, false);
        }
        throw new FrameworkException(500, "No request object present, aborting.");
    }

    @Override
    public RestMethodResult doPost(Map<String, Object> propertySet) throws FrameworkException {
        HttpServletRequest request = this.securityContext.getRequest();
        if (request != null) {
            if ("true".equals(request.getParameter("initialize"))) {
                String filesPath = Services.getInstance().getConfigurationValue("files.path");
                try (Context context = new Context(1000);){
                    this.collectFilesAndStore(context, new File(filesPath + SUBJECTS).toPath(), 0);
                }
                catch (FrameworkException fex) {
                    logger.log(Level.WARNING, "", fex);
                }
                return new RestMethodResult(200);
            }
            String subjectId = (String)propertySet.get(subjectProperty.jsonName());
            String objectId = (String)propertySet.get(objectProperty.jsonName());
            String action = (String)propertySet.get(actionProperty.jsonName());
            String message = (String)propertySet.get(messageProperty.jsonName());
            if (subjectId != null && objectId != null && action != null) {
                App app = StructrApp.getInstance((SecurityContext)this.securityContext);
                LogEvent event = null;
                try (Tx tx = app.tx();){
                    PropertyMap properties = new PropertyMap();
                    properties.put(LogEvent.timestampProperty, (Object)new Date());
                    properties.put(LogEvent.actionProperty, (Object)action);
                    properties.put(LogEvent.subjectProperty, (Object)subjectId);
                    properties.put(LogEvent.objectProperty, (Object)objectId);
                    properties.put(LogEvent.messageProperty, (Object)message);
                    properties.put((PropertyKey)LogEvent.visibleToPublicUsers, (Object)true);
                    properties.put((PropertyKey)LogEvent.visibleToAuthenticatedUsers, (Object)true);
                    event = (LogEvent)app.create(LogEvent.class, properties);
                    tx.success();
                }
                RestMethodResult result = new RestMethodResult(201);
                result.addContent((GraphObject)event);
                return result;
            }
            ErrorBuffer errorBuffer = new ErrorBuffer();
            if (StringUtils.isEmpty((CharSequence)subjectId)) {
                errorBuffer.add((ErrorToken)new EmptyPropertyToken("LogFile", subjectProperty));
            }
            if (StringUtils.isEmpty((CharSequence)objectId)) {
                errorBuffer.add((ErrorToken)new EmptyPropertyToken("LogFile", objectProperty));
            }
            if (StringUtils.isEmpty((CharSequence)action)) {
                errorBuffer.add((ErrorToken)new EmptyPropertyToken("LogFile", actionProperty));
            }
            throw new FrameworkException(422, "Log entry must consist of at least subjectId, objectId and action", errorBuffer);
        }
        throw new FrameworkException(500, "No request object present, aborting.");
    }

    @Override
    public RestMethodResult doPut(Map<String, Object> propertySet) throws FrameworkException {
        throw new IllegalMethodException("PUT not allowed on " + this.getResourceSignature());
    }

    @Override
    public RestMethodResult doDelete() throws FrameworkException {
        throw new IllegalMethodException("DELETE not allowed on " + this.getResourceSignature());
    }

    @Override
    public RestMethodResult doHead() throws FrameworkException {
        throw new IllegalMethodException("HEAD not allowed on " + this.getResourceSignature());
    }

    @Override
    public RestMethodResult doOptions() throws FrameworkException {
        RestMethodResult result = new RestMethodResult(200);
        result.addHeader("Allow", "GET,POST,OPTIONS");
        return result;
    }

    @Override
    public boolean createPostTransaction() {
        return false;
    }

    private void collectFilesAndStore(Context context, Path dir, int level) throws FrameworkException {
        if (level == 1) {
            logger.log(Level.INFO, "Path {0}", dir);
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path p : stream) {
                if (Files.isDirectory(p, new LinkOption[0])) {
                    this.collectFilesAndStore(context, p, level + 1);
                } else {
                    context.update(this.storeLogEntry(p));
                    context.commit(true);
                }
                Files.delete(p);
            }
        }
        catch (IOException ioex) {
            logger.log(Level.WARNING, "", ioex);
        }
    }

    private void processData(LogState state) throws FrameworkException {
        if (state.doCorrelate()) {
            List correlationResult = StructrApp.getInstance((SecurityContext)this.securityContext).nodeQuery(LogEvent.class).and(LogEvent.actionProperty, (Object)state.correlationAction).getAsList();
            for (LogEvent entry : correlationResult) {
                String pathSubjectId = state.inverse() ? entry.getObjectId() : entry.getSubjectId();
                String pathObjectId = state.inverse() ? entry.getSubjectId() : entry.getObjectId();
                String entryMessage = entry.getMessage();
                if (state.correlationPattern != null) {
                    Matcher matcher = state.correlationPattern.matcher(entryMessage);
                    if (!matcher.matches()) continue;
                    state.addCorrelationEntry(matcher.group(1), entry);
                    continue;
                }
                state.addCorrelationEntry(LogResource.key(pathSubjectId, pathObjectId), entry);
            }
        }
        logger.log(Level.FINE, "No. of correlations: {0}", state.getCorrelations().entrySet().size());
        List result = StructrApp.getInstance((SecurityContext)this.securityContext).nodeQuery(LogEvent.class).and(LogEvent.actionProperty, (Object)state.logAction).andRange(LogEvent.timestampProperty, (Object)new Date(state.beginTimestamp()), (Object)new Date(state.endTimestamp())).getAsList();
        this.processData(state, result);
    }

    private void processData(LogState state, Iterable<LogEvent> result) throws FrameworkException {
        int count = 0;
        for (LogEvent event : result) {
            if (++count % 100000 == 0) {
                System.out.println(count);
            }
            String pathSubjectId = state.inverse() ? event.getObjectId() : event.getSubjectId();
            String pathObjectId = state.inverse() ? event.getSubjectId() : event.getObjectId();
            long timestamp = event.getTimestamp();
            String entryAction = event.getAction();
            String entryMessage = event.getMessage();
            if (timestamp <= state.beginTimestamp()) {
                state.beginTimestamp(timestamp);
            }
            if (timestamp >= state.endTimestamp()) {
                state.endTimestamp(timestamp);
            }
            if (state.overview()) {
                if (entryAction != null) {
                    state.countAction(entryAction);
                    continue;
                }
                state.countAction("null");
                continue;
            }
            if (!state.passesFilter(entryMessage) || !state.correlates(pathSubjectId, pathObjectId, entryMessage)) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(subjectProperty.jsonName(), pathSubjectId);
            map.put(objectProperty.jsonName(), pathObjectId);
            map.put(actionProperty.jsonName(), entryAction);
            map.put(timestampProperty.jsonName(), timestamp);
            map.put(messageProperty.jsonName(), entryMessage);
            state.addEntry(map);
        }
    }

    private int storeLogEntry(Path path) throws IOException, FrameworkException {
        App app = StructrApp.getInstance((SecurityContext)this.securityContext);
        String fileName = path.getFileName().toString();
        int count = 0;
        if (fileName.length() == 64) {
            String subjectId = fileName.substring(0, 32);
            String objectId = fileName.substring(32, 64);
            for (String line : Files.readAllLines(path, Charset.forName("utf-8"))) {
                int pos1 = line.indexOf(",", 14);
                String part0 = line.substring(0, 13);
                String part1 = line.substring(14, pos1);
                String part2 = line.substring(pos1 + 1);
                long timestamp = Long.valueOf(part0);
                String action = part1;
                String message = part2;
                PropertyMap properties = new PropertyMap();
                properties.put(LogEvent.messageProperty, (Object)message);
                properties.put(LogEvent.actionProperty, (Object)action);
                properties.put(LogEvent.subjectProperty, (Object)subjectId);
                properties.put(LogEvent.objectProperty, (Object)objectId);
                properties.put(LogEvent.timestampProperty, (Object)new Date(timestamp));
                properties.put((PropertyKey)LogEvent.visibleToPublicUsers, (Object)true);
                properties.put((PropertyKey)LogEvent.visibleToAuthenticatedUsers, (Object)true);
                app.create(LogEvent.class, properties);
                ++count;
            }
        } else {
            System.out.println("Skipping entry " + fileName);
        }
        return count;
    }

    private String getDirectoryPath(String uuid, int depth) {
        StringBuilder buf = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)uuid) && uuid.length() > depth) {
            for (int i = 0; i < depth; ++i) {
                buf.append(uuid.substring(i, i + 1));
                buf.append("/");
            }
        }
        return buf.toString();
    }

    private Result aggregate(LogState state) throws FrameworkException {
        state.sortEntries();
        long startTimestamp = state.beginTimestamp();
        long endTimestamp = state.endTimestamp();
        GraphObjectMap result = new GraphObjectMap();
        long interval = this.findInterval(state.aggregate());
        long start = this.alignDateOnFormat(state.aggregate(), startTimestamp);
        TreeMap<Long, Map<String, Object>> countMap = this.toAggregatedCountMap(state);
        Set<String> countProperties = this.getCountProperties(countMap);
        for (long current = start; current <= endTimestamp; current += interval) {
            NavigableMap<Long, Map<String, Object>> counts = countMap.subMap(current, true, current + interval, false);
            GraphObjectMap sum = new GraphObjectMap();
            for (String key : countProperties) {
                sum.put((PropertyKey)new IntProperty(key), (Object)0);
            }
            for (Map count : counts.values()) {
                for (String key : countProperties) {
                    Integer entryValue;
                    IntProperty prop = new IntProperty(key);
                    Integer sumValue = (Integer)sum.get((PropertyKey)prop);
                    if (sumValue == null) {
                        sumValue = 0;
                    }
                    if ((entryValue = (Integer)count.get(key)) == null) {
                        entryValue = 0;
                    }
                    sum.put((PropertyKey)prop, (Object)(sumValue + entryValue));
                }
            }
            result.put((PropertyKey)new GenericProperty(Long.toString(current)), (Object)sum);
        }
        return new Result((GraphObject)result, false);
    }

    private Result histogram(LogState state) throws FrameworkException {
        state.sortEntries();
        String dateFormat = state.aggregate();
        long startTimestamp = state.beginTimestamp();
        long endTimestamp = state.endTimestamp();
        GraphObjectMap result = new GraphObjectMap();
        long interval = this.findInterval(dateFormat);
        long start = this.alignDateOnFormat(dateFormat, startTimestamp);
        TreeMap<Long, Map<String, Object>> countMap = this.toHistogramCountMap(state);
        Set<String> countProperties = this.getCountProperties(countMap);
        for (long current = start; current <= endTimestamp; current += interval) {
            NavigableMap<Long, Map<String, Object>> counts = countMap.subMap(current, true, current + interval, false);
            GraphObjectMap sum = new GraphObjectMap();
            for (String key : countProperties) {
                sum.put((PropertyKey)new IntProperty(key), (Object)0);
            }
            for (Map count : counts.values()) {
                for (String key : countProperties) {
                    Integer entryValue;
                    IntProperty prop = new IntProperty(key);
                    Integer sumValue = (Integer)sum.get((PropertyKey)prop);
                    if (sumValue == null) {
                        sumValue = 0;
                    }
                    if ((entryValue = (Integer)count.get(key)) == null) {
                        entryValue = 0;
                    }
                    sum.put((PropertyKey)prop, (Object)(sumValue + entryValue));
                }
            }
            result.put((PropertyKey)new GenericProperty(Long.toString(current)), (Object)sum);
        }
        return new Result((GraphObject)result, false);
    }

    private long alignDateOnFormat(String dateFormat, long timestamp) {
        try {
            SimpleDateFormat format = new SimpleDateFormat(dateFormat);
            return format.parse(format.format(timestamp)).getTime();
        }
        catch (ParseException pex) {
            logger.log(Level.WARNING, "", pex);
            return 0L;
        }
    }

    private long findInterval(String dateFormat) {
        long max = TimeUnit.DAYS.toMillis(365L);
        long step = TimeUnit.SECONDS.toMillis(60L);
        try {
            long initial;
            SimpleDateFormat format = new SimpleDateFormat(dateFormat);
            for (long i = initial = format.parse(format.format(3600)).getTime(); i < max; i += step) {
                long current = format.parse(format.format(i)).getTime();
                if (initial == current) continue;
                return i - initial;
            }
            return max;
        }
        catch (ParseException pex) {
            logger.log(Level.WARNING, "", pex);
            return max;
        }
    }

    private TreeMap<Long, Map<String, Object>> toAggregatedCountMap(LogState state) throws FrameworkException {
        TreeMap<Long, Map<String, Object>> countMap = new TreeMap<Long, Map<String, Object>>();
        for (Map<String, Object> entry : state.entries()) {
            Integer count;
            String message = (String)entry.get(messageProperty.jsonName());
            long timestamp = (Long)entry.get(timestampProperty.jsonName());
            Map<String, Object> obj = countMap.get(timestamp);
            if (obj == null) {
                obj = new LinkedHashMap<String, Object>();
            }
            count = (count = (Integer)obj.get(totalProperty.jsonName())) == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
            obj.put(totalProperty.jsonName(), count);
            for (Map.Entry<String, Pattern> patternEntry : state.aggregationPatterns().entrySet()) {
                if (!patternEntry.getValue().matcher(message).matches()) continue;
                String key = patternEntry.getKey();
                int multiplier = this.getMultiplier(message, state);
                Integer c = (Integer)obj.get(key);
                c = c == null ? Integer.valueOf(multiplier) : Integer.valueOf(c + multiplier);
                obj.put(key, c);
            }
            countMap.put(timestamp, obj);
        }
        return countMap;
    }

    private TreeMap<Long, Map<String, Object>> toHistogramCountMap(LogState state) throws FrameworkException {
        Pattern pattern = Pattern.compile(state.histogram());
        Matcher matcher = pattern.matcher("");
        TreeMap<Long, Map<String, Object>> countMap = new TreeMap<Long, Map<String, Object>>();
        for (Map<String, Object> entry : state.entries()) {
            Integer count;
            String message = (String)entry.get(messageProperty.jsonName());
            long timestamp = (Long)entry.get(timestampProperty.jsonName());
            Map<String, Object> obj = countMap.get(timestamp);
            if (obj == null) {
                obj = new LinkedHashMap<String, Object>();
            }
            count = (count = (Integer)obj.get(totalProperty.jsonName())) == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
            obj.put(totalProperty.jsonName(), count);
            matcher.reset(message);
            if (matcher.matches()) {
                String key = matcher.group(1);
                int multiplier = this.getMultiplier(message, state);
                Integer c = (Integer)obj.get(key);
                c = c == null ? Integer.valueOf(multiplier) : Integer.valueOf(c + multiplier);
                obj.put(key, c);
            }
            countMap.put(timestamp, obj);
        }
        return countMap;
    }

    private int getMultiplier(String message, LogState state) {
        Matcher matcher;
        Integer multiplier = 1;
        if (state.multiplier != null && (matcher = Pattern.compile(state.multiplier).matcher(message)).matches()) {
            String g = matcher.group(1);
            multiplier = Integer.parseInt(g);
        }
        return multiplier;
    }

    private Set<String> getCountProperties(Map<Long, Map<String, Object>> entries) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Map<String, Object> obj : entries.values()) {
            for (Map.Entry<String, Object> entry : obj.entrySet()) {
                if (!(entry.getValue() instanceof Integer)) continue;
                result.add(entry.getKey());
            }
        }
        return result;
    }

    private List<GraphObjectMap> wrap(List<Map<String, Object>> entries) {
        LinkedList<GraphObjectMap> result = new LinkedList<GraphObjectMap>();
        for (Map<String, Object> entry : entries) {
            GraphObjectMap map = new GraphObjectMap();
            for (Map.Entry<String, Object> e : entry.entrySet()) {
                String key = e.getKey();
                if (timestampProperty.jsonName().equals(key)) {
                    map.put((PropertyKey)timestampProperty, (Object)new Date((Long)e.getValue()));
                    continue;
                }
                map.put((PropertyKey)new GenericProperty(key), e.getValue());
            }
            result.add(map);
        }
        return result;
    }

    private <T> Set<T> toSet(T element) {
        HashSet<T> set = new HashSet<T>();
        set.add(element);
        return set;
    }

    private <T> Set<T> toSet(Iterable<T> iterable) {
        HashSet<T> set = new HashSet<T>();
        for (T path : iterable) {
            set.add(path);
        }
        return set;
    }

    private static String key(String subjectId, String objectId) {
        if (subjectId != null && objectId != null) {
            return subjectId.concat(objectId);
        }
        return "NULLNULL";
    }

    private static class Context
    implements AutoCloseable {
        private final App app = StructrApp.getInstance();
        private Tx tx = null;
        private int total = 0;
        private int count = 0;
        private int commitCount = 0;

        public Context(int commitCount) {
            this.commitCount = commitCount;
            this.tx = this.app.tx(false, false, false);
        }

        public void commit(boolean intermediate) throws FrameworkException {
            if (this.count > this.commitCount) {
                logger.log(Level.INFO, "Committing transaction after {0} objects..", this.total);
                this.tx.success();
                this.tx.close();
                if (intermediate) {
                    this.tx = this.app.tx(false, false, false);
                }
                this.count = 0;
            }
        }

        public int getTotal() {
            return this.total;
        }

        public void update(int count) {
            this.count += count;
            this.total += count;
        }

        @Override
        public void close() throws FrameworkException {
            this.tx.success();
            this.tx.close();
        }
    }

    private static class TimestampComparator
    implements Comparator<Map<String, Object>> {
        private TimestampComparator() {
        }

        @Override
        public int compare(Map<String, Object> o1, Map<String, Object> o2) {
            Long timestamp1 = (Long)o1.get(timestampProperty.jsonName());
            Long timestamp2 = (Long)o2.get(timestampProperty.jsonName());
            return timestamp1.compareTo(timestamp2);
        }
    }

    private static class Range {
        private long start = 0L;
        private long end = 0L;

        public Range(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public boolean contains(long timestamp) {
            return timestamp >= this.start && timestamp <= this.end;
        }
    }

    private static class LogState {
        private final Map<String, Pattern> aggregationPatterns = new HashMap<String, Pattern>();
        private final List<Map<String, Object>> entries = new LinkedList<Map<String, Object>>();
        private final Map<String, LinkedList<LogEvent>> correlations = new ConcurrentHashMap<String, LinkedList<LogEvent>>();
        private final Map<String, Integer> actions = new HashMap<String, Integer>();
        private long beginTimestamp = Long.MAX_VALUE;
        private long endTimestamp = 0L;
        private String logAction = null;
        private String aggregate = null;
        private String histogram = null;
        private String multiplier = null;
        private String correlate = null;
        private String correlationAction = null;
        private String correlationOp = null;
        private Pattern correlationPattern = null;
        private String[] filters = null;
        private boolean inverse = false;
        private boolean overview = false;
        private Range range = null;
        private int actionCount = 0;
        private boolean doCorrelate = false;

        public LogState(HttpServletRequest request) {
            this.aggregationPatterns.putAll(this.getAggregationPatterns(request));
            this.logAction = request.getParameter(actionProperty.jsonName());
            this.aggregate = request.getParameter("aggregate");
            this.histogram = request.getParameter("histogram");
            this.correlate = request.getParameter("correlate");
            this.multiplier = request.getParameter("multiplier");
            this.filters = this.getFilterPatterns(request);
            this.range = this.getRange(request);
            if (StringUtils.isNotBlank((CharSequence)this.correlate)) {
                String[] parts = this.correlate.split(LogResource.CORRELATION_SEPARATOR);
                if (parts.length > 0) {
                    this.correlationAction = parts[0];
                }
                if (parts.length > 1) {
                    this.correlationOp = parts[1];
                }
                if (parts.length > 2) {
                    this.correlationPattern = Pattern.compile(parts[2]);
                }
                this.doCorrelate = true;
            }
        }

        public List<Map<String, Object>> entries() {
            return this.entries;
        }

        public void addEntry(Map<String, Object> entry) {
            this.entries.add(entry);
        }

        public void addCorrelationEntry(String key, LogEvent event) {
            logger.log(Level.FINE, "No. of correllation entry lists: {0}, adding action: {1} {2}", new Object[]{this.correlations.keySet().size(), key, event.getMessage()});
            LinkedList<LogEvent> existingEventList = this.correlations.get(key);
            if (existingEventList == null) {
                existingEventList = new LinkedList();
            }
            existingEventList.add(event);
            this.correlations.put(key, existingEventList);
        }

        public Map<String, LinkedList<LogEvent>> getCorrelations() {
            return this.correlations;
        }

        public Map<String, Integer> actions() {
            return this.actions;
        }

        public Map<String, Pattern> aggregationPatterns() {
            return this.aggregationPatterns;
        }

        public void countAction(String action) {
            Integer actionCount = this.actions.get(action);
            if (actionCount == null) {
                this.actions.put(action, 1);
            } else {
                this.actions.put(action, actionCount + 1);
            }
            ++this.actionCount;
        }

        public int actionCount() {
            return this.actionCount;
        }

        public boolean isRequestedActionOrNull(String action) {
            return this.logAction == null || this.logAction.equals(action);
        }

        public void sortEntries() {
            Collections.sort(this.entries, new TimestampComparator());
        }

        public int size() {
            return this.entries.size();
        }

        public void inverse(boolean inverse) {
            this.inverse = inverse;
        }

        public boolean inverse() {
            return this.inverse;
        }

        public void overview(boolean overview) {
            this.overview = overview;
        }

        public boolean overview() {
            return this.overview;
        }

        public long beginTimestamp() {
            return this.range != null ? this.range.start : this.beginTimestamp;
        }

        public long endTimestamp() {
            return this.range != null ? this.range.end : this.endTimestamp;
        }

        public void beginTimestamp(long beginTimestamp) {
            this.beginTimestamp = beginTimestamp;
        }

        public void endTimestamp(long endTimestamp) {
            this.endTimestamp = endTimestamp;
        }

        public boolean isInRangeOrNull(long timestamp) {
            return this.range == null || this.range.contains(timestamp);
        }

        public String histogram() {
            return this.histogram;
        }

        public String aggregate() {
            return this.aggregate;
        }

        public boolean passesFilter(String message) {
            if (this.filters == null) {
                return true;
            }
            boolean passes = true;
            for (String filter : this.filters) {
                passes &= Pattern.compile(filter).matcher(message).matches();
            }
            return passes;
        }

        public boolean correlates(String pathSubjectId, String pathObjectId, String message) {
            if (this.correlations.isEmpty()) {
                return true;
            }
            if (this.correlationOp != null && this.correlationPattern != null) {
                Matcher matcher = this.correlationPattern.matcher(message);
                if (matcher.matches()) {
                    String value = matcher.group(1);
                    switch (this.correlationOp) {
                        case "and": {
                            return this.correlations.containsKey(value);
                        }
                        case "andSubject": {
                            LinkedList<LogEvent> correlationEntries = this.correlations.get(value);
                            if (correlationEntries != null) {
                                for (LogEvent correlationEntry : correlationEntries) {
                                    if (!correlationEntry.getSubjectId().equals(pathSubjectId)) continue;
                                    return true;
                                }
                            }
                            return false;
                        }
                        case "andObject": {
                            LinkedList<LogEvent> correlationEntries = this.correlations.get(value);
                            if (correlationEntries != null) {
                                for (LogEvent correlationEntry : correlationEntries) {
                                    if (!correlationEntry.getObjectId().equals(pathObjectId)) continue;
                                    return true;
                                }
                            }
                            return false;
                        }
                        case "not": {
                            return !this.correlations.containsKey(value);
                        }
                    }
                    return false;
                }
                return "not".equals(this.correlationOp);
            }
            return this.correlations.containsKey(LogResource.key(pathSubjectId, pathObjectId));
        }

        public boolean isCorrelatedAction(String input) {
            return this.correlationAction == null || this.correlationAction.equals(input);
        }

        public boolean doHistogram() throws FrameworkException {
            if (StringUtils.isNotBlank((CharSequence)this.histogram)) {
                if (StringUtils.isBlank((CharSequence)this.aggregate)) {
                    throw new FrameworkException(400, "To use the histogram function, please supply an aggregation pattern.");
                }
                return true;
            }
            return false;
        }

        public boolean doAggregate() {
            return StringUtils.isNotBlank((CharSequence)this.aggregate);
        }

        public boolean doCorrelate() {
            return this.doCorrelate;
        }

        public boolean doActionQuery() {
            return StringUtils.isNotBlank((CharSequence)this.logAction);
        }

        public boolean includeFile(File file) {
            return this.range == null || this.range.contains(file.lastModified());
        }

        private Range getRange(HttpServletRequest request) {
            Matcher matcher;
            String value = request.getParameter(timestampProperty.jsonName());
            if (value != null && StringUtils.startsWith((CharSequence)value, (CharSequence)"[") && StringUtils.endsWith((CharSequence)value, (CharSequence)"]") && (matcher = RangeQueryPattern.matcher(value)).matches() && matcher.groupCount() == 2) {
                SimpleDateFormat parser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
                String rangeStart = matcher.group(1);
                String rangeEnd = matcher.group(2);
                try {
                    Date startDate = parser.parse(rangeStart);
                    Date endDate = parser.parse(rangeEnd);
                    return new Range(startDate.getTime(), endDate.getTime());
                }
                catch (ParseException pex) {
                    logger.log(Level.WARNING, "", pex);
                }
            }
            return null;
        }

        private Map<String, Pattern> getAggregationPatterns(HttpServletRequest request) {
            LinkedHashMap<String, Pattern> patterns = new LinkedHashMap<String, Pattern>();
            for (Map.Entry entry : request.getParameterMap().entrySet()) {
                String key = (String)entry.getKey();
                String[] value = (String[])entry.getValue();
                if (value.length <= 0 || ReservedRequestParameters.contains(key)) continue;
                patterns.put(key, Pattern.compile(value[0]));
            }
            return patterns;
        }

        private String[] getFilterPatterns(HttpServletRequest request) {
            String filterString = request.getParameter("filters");
            if (StringUtils.isNotBlank((CharSequence)filterString)) {
                return filterString.split(LogResource.CORRELATION_SEPARATOR);
            }
            return null;
        }
    }
}

