/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.auth;

import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.server.session.AbstractSession;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.structr.common.error.FrameworkException;
import org.structr.core.Services;
import org.structr.core.app.App;
import org.structr.core.app.Query;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.Principal;
import org.structr.core.property.PropertyKey;
import org.structr.rest.auth.AuthHelper;
import org.structr.rest.service.HttpService;

public class SessionHelper {
    public static final String STANDARD_ERROR_MSG = "Wrong username or password, or user is blocked. Check caps lock. Note: Username is case sensitive!";
    public static final String SESSION_IS_NEW = "SESSION_IS_NEW";
    private static final Logger logger = Logger.getLogger(SessionHelper.class.getName());

    public static boolean isSessionTimedOut(HttpSession session) {
        if (session == null) {
            return true;
        }
        long now = new Date().getTime();
        try {
            long lastAccessed = session.getLastAccessedTime();
            if (now > lastAccessed + (long)(Services.getGlobalSessionTimeout() * 1000)) {
                logger.log(Level.INFO, "Session {0} timed out, last accessed at {1}", new Object[]{session, lastAccessed});
                return true;
            }
            return false;
        }
        catch (IllegalStateException ise) {
            return true;
        }
    }

    public static HttpSession getSessionBySessionId(String sessionId) throws FrameworkException {
        return ((HttpService)Services.getInstance().getService(HttpService.class)).getHashSessionManager().getSession(sessionId);
    }

    public static HttpSession newSession(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        if (session == null) {
            session = request.getSession(true);
        }
        if (session != null) {
            session.setMaxInactiveInterval(Services.getGlobalSessionTimeout());
        } else {
            logger.log(Level.SEVERE, "Unable to create new session after two attempts");
        }
        return session;
    }

    public static void clearSession(String sessionId) {
        App app = StructrApp.getInstance();
        Query query = app.nodeQuery(Principal.class).and((PropertyKey)Principal.sessionIds, (Object)new String[]{sessionId});
        try {
            List principals = query.getAsList();
            for (Principal p : principals) {
                p.removeSessionId(sessionId);
            }
        }
        catch (FrameworkException fex) {
            logger.log(Level.WARNING, "Error while removing sessionId " + sessionId + " from all principals", fex);
        }
    }

    public static void clearInvalidSessions(Principal user) {
        logger.log(Level.INFO, "Clearing invalid sessions for user {0}", user);
        HashSessionManager sessionManager = ((HttpService)Services.getInstance().getService(HttpService.class)).getHashSessionManager();
        String[] sessionIds = (String[])user.getProperty((PropertyKey)Principal.sessionIds);
        if (sessionIds != null && sessionIds.length > 0) {
            for (String sessionId : (String[])user.getProperty((PropertyKey)Principal.sessionIds)) {
                AbstractSession session = sessionManager.getSession(sessionId);
                if (session != null && !SessionHelper.isSessionTimedOut((HttpSession)session)) continue;
                SessionHelper.clearSession(sessionId);
            }
        }
    }

    public static void invalidateSession(HttpSession session) {
        if (session != null) {
            try {
                session.invalidate();
            }
            catch (IllegalArgumentException iae) {
                logger.log(Level.WARNING, "Invalidating already invalidated session failed: {0}", session.getId());
            }
        }
    }

    public static Principal checkSessionAuthentication(HttpServletRequest request) throws FrameworkException {
        String requestedSessionId = request.getRequestedSessionId();
        HttpSession session = request.getSession(false);
        boolean sessionValid = false;
        if (requestedSessionId == null) {
            SessionHelper.newSession(request);
            request.setAttribute(SESSION_IS_NEW, (Object)true);
            return null;
        }
        if (session != null) {
            if (session.getId().equals(requestedSessionId)) {
                if (SessionHelper.isSessionTimedOut(session)) {
                    sessionValid = false;
                    SessionHelper.clearSession(requestedSessionId);
                } else {
                    sessionValid = true;
                }
            }
        } else {
            session = SessionHelper.newSession(request);
            SessionHelper.clearSession(requestedSessionId);
        }
        if (sessionValid) {
            Principal user = AuthHelper.getPrincipalForSessionId(session.getId());
            logger.log(Level.FINE, "Valid session found: {0}, last accessed {1}, authenticated with user {2}", new Object[]{session, session.getLastAccessedTime(), user});
            return user;
        }
        Principal user = AuthHelper.getPrincipalForSessionId(requestedSessionId);
        logger.log(Level.FINE, "Invalid session: {0}, last accessed {1}, authenticated with user {2}", new Object[]{session, session != null ? Long.valueOf(session.getLastAccessedTime()) : "", user});
        if (user != null) {
            AuthHelper.doLogout(request, user);
        }
        try {
            request.logout();
            request.changeSessionId();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

