/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.core.logging;

import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.LogManager;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.RootLogger;
import org.ssssssss.magicapi.core.logging.Formatter;
import org.ssssssss.magicapi.core.logging.MagicLoggerContext;

public class Log4jLoggerContext
implements MagicLoggerContext {
    @Override
    public void generateAppender() {
        RootLogger logger = (RootLogger)LogManager.getRootLogger();
        PatternLayout patternLayout = new PatternLayout("%d %p [%c] - %m%n");
        MagicLog4jAppender magicLog4jAppender = new MagicLog4jAppender();
        magicLog4jAppender.setLayout((Layout)patternLayout);
        logger.addAppender((Appender)magicLog4jAppender);
    }

    static class MagicLog4jAppender
    extends AppenderSkeleton {
        MagicLog4jAppender() {
        }

        protected void append(LoggingEvent event) {
            String message = Formatter.create().timestamp(event.getTimeStamp()).space().level(event.getLevel().toString()).value(" --- [").thread(event.getThreadName()).value("] ").loggerName(event.getLoggerName()).value(": ").value(event.getRenderedMessage()).newline().throwable(event.getThrowableInformation() == null ? null : event.getThrowableInformation().getThrowable()).toString();
            MagicLoggerContext.println(message);
        }

        public void close() {
        }

        public boolean requiresLayout() {
            return false;
        }
    }
}

