/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.module.support;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public class ParentLastURLClassLoader
extends URLClassLoader {
    private final ClassLoader system;
    private static final String[] SPECIAL_CASES = new String[]{"META-INF/spring.handlers", "META-INF/spring.schemas"};
    private boolean byPassSystemClassLoaderForResources = false;

    public ParentLastURLClassLoader(URL[] classpath, ClassLoader parent) {
        this(classpath, parent, false);
    }

    public ParentLastURLClassLoader(URL[] classpath, ClassLoader parent, boolean byPassSystemClassLoaderForResources) {
        super(ParentLastURLClassLoader.wrapNull(classpath), parent);
        ClassLoader sys = ParentLastURLClassLoader.getSystemClassLoader();
        while (sys.getParent() != null) {
            sys = sys.getParent();
        }
        this.system = sys;
        this.byPassSystemClassLoaderForResources = byPassSystemClassLoaderForResources;
    }

    private static URL[] wrapNull(URL[] classpath) {
        return classpath == null ? new URL[]{} : classpath;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            if (this.system != null) {
                try {
                    c = this.system.loadClass(name);
                }
                catch (ClassNotFoundException ignored) {
                    // empty catch block
                }
            }
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    c = super.loadClass(name, resolve);
                }
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public URL getResource(String name) {
        URL url = null;
        if (this.system != null && !this.byPassSystemClassLoaderForResources) {
            url = this.system.getResource(name);
        }
        if (url == null && (url = this.findResource(name)) == null) {
            url = super.getResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (this.system != null) {
            urls.addAll(Collections.list(this.system.getResources(name)));
        }
        ArrayList<URL> fromSelf = Collections.list(this.findResources(name));
        ClassLoader parent = this.getParent();
        List fromParent = Collections.emptyList();
        if (parent != null) {
            fromParent = Collections.list(parent.getResources(name));
        }
        if (!this.isSpecialCase(name)) {
            urls.addAll(fromSelf);
            urls.addAll(fromParent);
        } else {
            urls.addAll(fromParent);
            urls.addAll(fromSelf);
        }
        return Collections.enumeration(urls);
    }

    public void setByPassSystemClassLoaderForResources(boolean byPassSystemClassLoaderForResources) {
        this.byPassSystemClassLoaderForResources = byPassSystemClassLoaderForResources;
    }

    private boolean isSpecialCase(String name) {
        for (String c : SPECIAL_CASES) {
            if (!c.equals(name)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ParentLastURLCL\r\nURLs: ");
        sb.append(Arrays.asList(this.getURLs()));
        sb.append("\nParent CL: ");
        sb.append(this.getParent());
        sb.append("\nSystem CL: ");
        sb.append(this.system);
        sb.append("\n");
        return sb.toString();
    }
}

