/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.module.options.support;

import java.util.EnumSet;
import org.springframework.boot.bind.RelaxedNames;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class StringToEnumIgnoringCaseConverterFactory
implements ConverterFactory<String, Enum> {
    public <T extends Enum> Converter<String, T> getConverter(Class<T> targetType) {
        Class<T> enumType;
        Assert.notNull(targetType, (String)"The target type must not be null.");
        for (enumType = targetType; enumType != null && !enumType.isEnum(); enumType = enumType.getSuperclass()) {
        }
        Assert.notNull(enumType, (String)("The target type " + targetType.getName() + " does not refer to an enum"));
        return new StringToEnum<T>(enumType);
    }

    private static class StringToEnum<T extends Enum>
    implements Converter<String, T> {
        private final Class<T> enumType;

        public StringToEnum(Class<T> enumType) {
            this.enumType = enumType;
        }

        public T convert(String source) {
            if (StringUtils.isEmpty((Object)source)) {
                return null;
            }
            source = source.trim();
            for (Enum candidate : EnumSet.allOf(this.enumType)) {
                RelaxedNames names = new RelaxedNames(candidate.name().replace("_", "-").toLowerCase());
                for (String name : names) {
                    if (!name.equals(source)) continue;
                    return (T)candidate;
                }
                if (!candidate.name().equalsIgnoreCase(source)) continue;
                return (T)candidate;
            }
            throw new ConversionFailedException(TypeDescriptor.valueOf(String.class), TypeDescriptor.valueOf(this.enumType), (Object)source, null);
        }
    }
}

