/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.module.options;

import java.util.HashSet;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.xd.module.options.HierarchicalCompositeModuleOptionsMetadata;
import org.springframework.xd.module.options.ModuleOptions;

public class PrefixNarrowingModuleOptions
extends ModuleOptions {
    private final ModuleOptions composedModuleOptions;
    private final String moduleName;

    public PrefixNarrowingModuleOptions(ModuleOptions composedModuleOptions, String moduleName) {
        this.composedModuleOptions = composedModuleOptions;
        this.moduleName = moduleName;
    }

    @Override
    public String[] profilesToActivate() {
        String[] encoded = this.composedModuleOptions.profilesToActivate();
        return HierarchicalCompositeModuleOptionsMetadata.filterQualifiedProfiles(encoded, this.moduleName);
    }

    @Override
    public EnumerablePropertySource<?> asPropertySource() {
        final EnumerablePropertySource<?> ps = this.composedModuleOptions.asPropertySource();
        final String prefix = this.moduleName + ".";
        return new EnumerablePropertySource<Object>(this.toString(), (Object)this.composedModuleOptions){

            public String[] getPropertyNames() {
                HashSet<String> result = new HashSet<String>();
                for (String name : ps.getPropertyNames()) {
                    if (!name.startsWith(prefix)) continue;
                    result.add(name.substring(prefix.length()));
                }
                return result.toArray(new String[result.size()]);
            }

            public Object getProperty(String name) {
                return ps.getProperty(prefix + name);
            }

            public boolean containsProperty(String name) {
                return ps.containsProperty(prefix + name);
            }
        };
    }
}

