/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.module.options;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.PropertyValues;
import org.springframework.boot.bind.PropertySourcesPropertyValues;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.util.Assert;
import org.springframework.validation.BindException;
import org.springframework.validation.DataBinder;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.CustomValidatorBean;
import org.springframework.xd.module.options.ModuleOption;
import org.springframework.xd.module.options.ModuleOptions;
import org.springframework.xd.module.options.ModuleOptionsMetadata;
import org.springframework.xd.module.options.spi.ProfileNamesProvider;
import org.springframework.xd.module.options.spi.ValidationGroupsProvider;

public class PojoModuleOptionsMetadata
implements ModuleOptionsMetadata {
    private BeanWrapperImpl beanWrapper;
    private List<ModuleOption> options;
    private final ConversionService conversionService;

    public PojoModuleOptionsMetadata(Class<?> clazz) {
        this(clazz, null);
    }

    public PojoModuleOptionsMetadata(Class<?> clazz, ConversionService conversionService) {
        this.conversionService = conversionService;
        this.beanWrapper = new BeanWrapperImpl(clazz);
        this.options = new ArrayList<ModuleOption>();
        for (PropertyDescriptor pd : this.beanWrapper.getPropertyDescriptors()) {
            String name = pd.getName();
            if (!this.beanWrapper.isWritableProperty(name)) continue;
            org.springframework.xd.module.options.spi.ModuleOption annotation = pd.getWriteMethod().getAnnotation(org.springframework.xd.module.options.spi.ModuleOption.class);
            Assert.notNull((Object)annotation, (String)String.format("Setter method for option '%s' needs to bear the @%s annotation and provide a description", name, org.springframework.xd.module.options.spi.ModuleOption.class.getSimpleName()));
            String description = this.descriptionFromAnnotation(name, annotation);
            Class type = BeanUtils.getWriteMethodParameter((PropertyDescriptor)pd).getParameterType();
            ModuleOption option = new ModuleOption(name, description).withType(type).hidden(annotation.hidden());
            if (this.beanWrapper.isReadableProperty(name)) {
                option.withDefaultValue(this.beanWrapper.getPropertyValue(name));
            } else {
                option.withDefaultValue(this.defaultFromAnnotation(annotation));
            }
            this.options.add(option);
        }
    }

    private Object defaultFromAnnotation(org.springframework.xd.module.options.spi.ModuleOption annotation) {
        String value = annotation.defaultValue();
        return "__NULL__".equals(value) ? null : value;
    }

    private String descriptionFromAnnotation(String optionName, org.springframework.xd.module.options.spi.ModuleOption annotation) {
        Assert.hasLength((String)annotation.value(), (String)String.format("Setter method for option '%s' needs to bear the @%s annotation and provide a non-empty description", optionName, org.springframework.xd.module.options.spi.ModuleOption.class.getSimpleName()));
        return annotation.value();
    }

    @Override
    public Iterator<ModuleOption> iterator() {
        return this.options.iterator();
    }

    @Override
    public ModuleOptions interpolate(Map<String, String> raw) throws BindException {
        this.bindAndValidate(raw);
        return new ModuleOptions(){

            @Override
            public EnumerablePropertySource<?> asPropertySource() {
                return new EnumerablePropertySource<BeanWrapper>(this.toString(), (BeanWrapper)PojoModuleOptionsMetadata.this.beanWrapper){

                    public String[] getPropertyNames() {
                        ArrayList<String> result = new ArrayList<String>();
                        for (PropertyDescriptor pd : PojoModuleOptionsMetadata.this.beanWrapper.getPropertyDescriptors()) {
                            String name = pd.getName();
                            if (!PojoModuleOptionsMetadata.this.beanWrapper.isReadableProperty(name) || "class".equals(name)) continue;
                            result.add(name);
                        }
                        return result.toArray(new String[result.size()]);
                    }

                    public Object getProperty(String name) {
                        if (Arrays.asList(this.getPropertyNames()).contains(name)) {
                            return PojoModuleOptionsMetadata.this.beanWrapper.getPropertyValue(name);
                        }
                        return null;
                    }
                };
            }

            @Override
            public String[] profilesToActivate() {
                if (PojoModuleOptionsMetadata.this.beanWrapper.getWrappedInstance() instanceof ProfileNamesProvider) {
                    return ((ProfileNamesProvider)PojoModuleOptionsMetadata.this.beanWrapper.getWrappedInstance()).profilesToActivate();
                }
                return super.profilesToActivate();
            }
        };
    }

    private void bindAndValidate(Map<String, String> raw) throws BindException {
        DataBinder dataBinder = new DataBinder(this.beanWrapper.getWrappedInstance());
        dataBinder.setIgnoreUnknownFields(false);
        dataBinder.setConversionService(this.conversionService);
        MutablePropertySources mps = new MutablePropertySources();
        mps.addFirst((PropertySource)new MapPropertySource("options", raw));
        try {
            dataBinder.bind((PropertyValues)new PropertySourcesPropertyValues((PropertySources)mps));
        }
        catch (InvalidPropertyException e) {
            dataBinder.getBindingResult().addError((ObjectError)new FieldError("options", e.getPropertyName(), e.getMessage()));
        }
        CustomValidatorBean validator = new CustomValidatorBean();
        validator.afterPropertiesSet();
        dataBinder.setValidator((Validator)validator);
        Class<?>[] groups = this.determineGroupsToUse(this.beanWrapper.getWrappedInstance());
        dataBinder.validate((Object[])groups);
        if (dataBinder.getBindingResult().hasErrors()) {
            throw new BindException(dataBinder.getBindingResult());
        }
    }

    private Class<?>[] determineGroupsToUse(Object pojo) {
        if (pojo instanceof ValidationGroupsProvider) {
            ValidationGroupsProvider groupsProvider = (ValidationGroupsProvider)pojo;
            return groupsProvider.groupsToValidate();
        }
        return ValidationGroupsProvider.DEFAULT_GROUP;
    }

    public String toString() {
        return String.format("%s backed by %s, defining options [%s]", this.getClass().getSimpleName(), this.beanWrapper.getWrappedClass(), this.options);
    }
}

