/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.module.options;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.springframework.boot.loader.archive.Archive;
import org.springframework.boot.loader.archive.ExplodedArchive;
import org.springframework.boot.loader.archive.JarFileArchive;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.xd.module.SimpleModuleDefinition;
import org.springframework.xd.module.options.ModuleOptions;
import org.springframework.xd.module.support.ArchiveResourceLoader;
import org.springframework.xd.module.support.NullClassLoader;
import org.springframework.xd.module.support.ParentLastURLClassLoader;

public class ModuleUtils {
    private static final List<String> DEFAULT_EXTRA_LIBS = Arrays.asList("/lib/*.jar", "/lib/*.zip");
    private static final String MODULE_CLASSPATH_KEY = "module.classpath";
    private static final PathMatchingResourcePatternResolver simpleResourceResolver = new PathMatchingResourcePatternResolver();

    public static ClassLoader createModuleRuntimeClassLoader(SimpleModuleDefinition definition, ModuleOptions moduleOptions, ClassLoader parent) {
        Resource moduleLocation = simpleResourceResolver.getResource(definition.getLocation());
        Properties moduleProperties = ModuleUtils.loadModuleProperties(definition);
        moduleProperties = moduleProperties == null ? new Properties() : moduleProperties;
        String extraLibsCSV = moduleProperties.getProperty(MODULE_CLASSPATH_KEY, StringUtils.collectionToCommaDelimitedString(DEFAULT_EXTRA_LIBS));
        ArrayList<String> extraLibs = new ArrayList<String>();
        String[] paths = extraLibsCSV.split("\\s*,\\s*");
        MutablePropertySources propertySources = new MutablePropertySources();
        propertySources.addFirst(moduleOptions.asPropertySource());
        PropertySourcesPropertyResolver placeHolderResolver = new PropertySourcesPropertyResolver((PropertySources)propertySources);
        for (String path : paths) {
            try {
                extraLibs.add(placeHolderResolver.resolveRequiredPlaceholders(path));
            }
            catch (IllegalArgumentException ignored) {
                // empty catch block
            }
        }
        return ModuleUtils.createModuleClassLoader(moduleLocation, parent, extraLibs);
    }

    public static ClassLoader createModuleDiscoveryClassLoader(Resource moduleLocation, ClassLoader parent) {
        return ModuleUtils.createModuleClassLoader(moduleLocation, parent, DEFAULT_EXTRA_LIBS);
    }

    private static ClassLoader createModuleClassLoader(Resource moduleLocation, ClassLoader parent, Iterable<String> patterns) {
        try {
            File moduleFile = moduleLocation.getFile();
            ExplodedArchive moduleArchive = moduleFile.isDirectory() ? new ExplodedArchive(moduleFile) : new JarFileArchive(moduleFile);
            ArrayList<URL> urls = new ArrayList<URL>();
            ArchiveResourceLoader resolver = new ArchiveResourceLoader((Archive)moduleArchive);
            for (String pattern : patterns) {
                for (Resource jar : resolver.getResources(pattern)) {
                    urls.add(jar.getURL());
                }
            }
            urls.add(moduleArchive.getUrl());
            return new ParentLastURLClassLoader(urls.toArray(new URL[urls.size()]), parent);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception creating module classloader for " + moduleLocation, e);
        }
    }

    public static Resource modulePropertiesFile(SimpleModuleDefinition definition) {
        return ModuleUtils.locateModuleResource(definition, ".properties");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties loadModuleProperties(SimpleModuleDefinition moduleDefinition) {
        Resource resource = ModuleUtils.modulePropertiesFile(moduleDefinition);
        if (resource == null) {
            return null;
        }
        Properties properties = new Properties();
        try (InputStream inputStream = resource.getInputStream();){
            properties.load(inputStream);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to read module properties for %s:%s", new Object[]{moduleDefinition.getName(), moduleDefinition.getType()}), e);
        }
    }

    public static Resource locateModuleResource(SimpleModuleDefinition definition, String extension) {
        Resource moduleLocation = simpleResourceResolver.getResource(definition.getLocation());
        Assert.isTrue((boolean)moduleLocation.exists(), (String)("module resource " + definition.getLocation() + " does not exist"));
        String ext = extension.startsWith(".") ? extension : "." + extension;
        try {
            ParentLastURLClassLoader insulatedClassLoader = new ParentLastURLClassLoader(new URL[]{moduleLocation.getURL()}, NullClassLoader.NO_PARENT, true);
            PathMatchingResourcePatternResolver moduleResolver = new PathMatchingResourcePatternResolver((ClassLoader)insulatedClassLoader);
            try {
                Object[] resources = moduleResolver.getResources("classpath:/config/*" + ext);
                if (resources.length > 1) {
                    throw new IllegalStateException("Multiple top level module resources found :" + StringUtils.arrayToCommaDelimitedString((Object[])resources));
                }
                if (resources.length == 1) {
                    Resource resource = resources[0];
                    if (resource instanceof ClassPathResource) {
                        return new UrlResource(resource.getURL());
                    }
                    return resource;
                }
            }
            catch (IOException e) {
                return null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Exception creating module classloader for " + moduleLocation, e);
        }
        return null;
    }

    public static Resource resourceBasedConfigurationFile(SimpleModuleDefinition moduleDefinition) {
        boolean groovyExists;
        Resource xml = ModuleUtils.locateModuleResource(moduleDefinition, ".xml");
        Resource groovy = ModuleUtils.locateModuleResource(moduleDefinition, ".groovy");
        boolean xmlExists = xml != null;
        boolean bl = groovyExists = groovy != null;
        if (xmlExists && groovyExists) {
            throw new IllegalStateException(String.format("Found both resources '%s' and '%s' for module %s", xml, groovy, moduleDefinition));
        }
        if (xmlExists) {
            return xml;
        }
        if (groovyExists) {
            return groovy;
        }
        return null;
    }
}

