/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.module.options;

import java.util.HashSet;
import java.util.Map;
import org.springframework.core.env.EnumerablePropertySource;

class HierarchicalEnumerablePropertySource
extends EnumerablePropertySource<Object> {
    private Map<String, EnumerablePropertySource<?>> delegates;

    public HierarchicalEnumerablePropertySource(String name, Map<String, EnumerablePropertySource<?>> delegates) {
        super(name, delegates);
        this.delegates = delegates;
    }

    public String[] getPropertyNames() {
        HashSet<String> result = new HashSet<String>(this.delegates.size() * 3);
        for (String prefix : this.delegates.keySet()) {
            String[] sub;
            for (String value : sub = this.delegates.get(prefix).getPropertyNames()) {
                result.add(prefix + "." + value);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public Object getProperty(String name) {
        int separator = name.indexOf(".");
        if (separator == -1) {
            return null;
        }
        String prefix = name.substring(0, separator);
        EnumerablePropertySource<?> sub = this.delegates.get(prefix);
        if (sub == null) {
            return null;
        }
        return sub.getProperty(name.substring(separator + ".".length()));
    }
}

