/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.module.options;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.xd.module.options.HierarchicalEnumerablePropertySource;
import org.springframework.xd.module.options.ModuleOption;
import org.springframework.xd.module.options.ModuleOptions;
import org.springframework.xd.module.options.ModuleOptionsMetadata;

public class HierarchicalCompositeModuleOptionsMetadata
implements ModuleOptionsMetadata {
    private Map<String, ModuleOptionsMetadata> composedModuleDefinitions;
    private List<ModuleOption> options = new ArrayList<ModuleOption>();
    private static final String HIERARCHICAL_PROFILE_SEPARATOR = "#";

    public HierarchicalCompositeModuleOptionsMetadata(Map<String, ModuleOptionsMetadata> hierarchy) {
        this.composedModuleDefinitions = hierarchy;
        for (Map.Entry<String, ModuleOptionsMetadata> entry : hierarchy.entrySet()) {
            for (ModuleOption option : entry.getValue()) {
                ModuleOption mo = new ModuleOption(entry.getKey() + "." + option.getName(), option.getDescription());
                mo.withDefaultValue(option.getDefaultValue()).withType(option.getType());
                this.options.add(mo);
            }
        }
    }

    @Override
    public Iterator<ModuleOption> iterator() {
        return this.options.iterator();
    }

    @Override
    public ModuleOptions interpolate(Map<String, String> raw) throws BindException {
        final HashMap<String, ModuleOptions> delegates = new HashMap<String, ModuleOptions>();
        HashMap valuesWithoutPrefix = new HashMap();
        for (String prefix : this.composedModuleDefinitions.keySet()) {
            valuesWithoutPrefix.put(prefix, new HashMap());
        }
        BeanPropertyBindingResult bindingResult = new BeanPropertyBindingResult((Object)this, "options");
        for (Map.Entry<String, String> entry : raw.entrySet()) {
            String key = entry.getKey();
            int separator = key.indexOf(".");
            if (separator == -1) {
                bindingResult.addError((ObjectError)new FieldError("options", key, String.format("unsupported option '%s'", key)));
                continue;
            }
            String prefix = key.substring(0, separator);
            String suffix = key.substring(separator + ".".length());
            Map map = (Map)valuesWithoutPrefix.get(prefix);
            if (map == null) {
                bindingResult.addError((ObjectError)new FieldError("options", key, String.format("unsupported option '%s'", key)));
                continue;
            }
            map.put(suffix, entry.getValue());
        }
        if (bindingResult.hasErrors()) {
            throw new BindException((BindingResult)bindingResult);
        }
        for (String prefix : this.composedModuleDefinitions.keySet()) {
            Map subMap = (Map)valuesWithoutPrefix.get(prefix);
            ModuleOptions interpolated = this.composedModuleDefinitions.get(prefix).interpolate(subMap);
            delegates.put(prefix, interpolated);
        }
        return new ModuleOptions(){

            @Override
            public EnumerablePropertySource<?> asPropertySource() {
                HashMap pss = new HashMap();
                for (Map.Entry entry : delegates.entrySet()) {
                    pss.put((String)entry.getKey(), ((ModuleOptions)entry.getValue()).asPropertySource());
                }
                return new HierarchicalEnumerablePropertySource("foo", pss);
            }

            @Override
            public String[] profilesToActivate() {
                ArrayList<String> result = new ArrayList<String>(delegates.size());
                for (String prefix : delegates.keySet()) {
                    ModuleOptions delegate = (ModuleOptions)delegates.get(prefix);
                    for (String p : delegate.profilesToActivate()) {
                        result.add(HierarchicalCompositeModuleOptionsMetadata.qualifyProfile(prefix, p));
                    }
                }
                return result.toArray(new String[result.size()]);
            }

            @Override
            public void validate() {
                for (ModuleOptions delegate : delegates.values()) {
                    delegate.validate();
                }
            }
        };
    }

    static String qualifyProfile(String prefix, String profile) {
        return String.format("%s%s%s", prefix, HIERARCHICAL_PROFILE_SEPARATOR, profile);
    }

    static String[] filterQualifiedProfiles(String[] whole, String moduleName) {
        ArrayList<String> result = new ArrayList<String>();
        for (String raw : whole) {
            String prefix = moduleName + HIERARCHICAL_PROFILE_SEPARATOR;
            if (!raw.startsWith(prefix)) continue;
            result.add(raw.substring(prefix.length()));
        }
        return result.toArray(new String[result.size()]);
    }
}

