/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.module.options;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.groovy.GroovyBeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.xd.module.CompositeModuleDefinition;
import org.springframework.xd.module.ModuleDefinition;
import org.springframework.xd.module.SimpleModuleDefinition;
import org.springframework.xd.module.options.DefaultModuleOptionsMetadataCollector;
import org.springframework.xd.module.options.FlattenedCompositeModuleOptionsMetadata;
import org.springframework.xd.module.options.HierarchicalCompositeModuleOptionsMetadata;
import org.springframework.xd.module.options.ModuleOption;
import org.springframework.xd.module.options.ModuleOptionsMetadata;
import org.springframework.xd.module.options.ModuleOptionsMetadataResolver;
import org.springframework.xd.module.options.ModuleUtils;
import org.springframework.xd.module.options.PassthruModuleOptionsMetadata;
import org.springframework.xd.module.options.PojoModuleOptionsMetadata;
import org.springframework.xd.module.options.SimpleModuleOptionsMetadata;
import org.springframework.xd.module.options.spi.Mixin;
import org.springframework.xd.module.options.support.StringToEnumIgnoringCaseConverterFactory;

public class DefaultModuleOptionsMetadataResolver
implements ModuleOptionsMetadataResolver,
ResourceLoaderAware {
    private static final Pattern DESCRIPTION_KEY_PATTERN = Pattern.compile("^options\\.([a-zA-Z\\-_0-9]+)\\.description$");
    public static final String OPTIONS_CLASS = "options_class";
    private static final Map<String, Class<?>> SHORT_CLASSNAMES = new HashMap();
    private ConversionService conversionService;
    private ModuleOptionsMetadataResolver compositeResolver = this;
    private final DefaultModuleOptionsMetadataCollector defaultModuleOptionsMetadataCollector = new DefaultModuleOptionsMetadataCollector();
    private ResourcePatternResolver resourceLoader = new PathMatchingResourcePatternResolver();
    private boolean shouldCreateModuleClassLoader = true;

    public DefaultModuleOptionsMetadataResolver() {
        GenericConversionService defaultConversionService = new GenericConversionService();
        defaultConversionService.addConverterFactory((ConverterFactory)new StringToEnumIgnoringCaseConverterFactory());
        this.conversionService = defaultConversionService;
    }

    public void setCompositeResolver(ModuleOptionsMetadataResolver compositeResolver) {
        this.compositeResolver = compositeResolver;
    }

    public void setShouldCreateModuleClassLoader(boolean shouldCreateModuleClassLoader) {
        this.shouldCreateModuleClassLoader = shouldCreateModuleClassLoader;
    }

    private ModuleOptionsMetadata makeSimpleModuleOptions(Properties props) {
        SimpleModuleOptionsMetadata result = new SimpleModuleOptionsMetadata();
        for (Object key : props.keySet()) {
            String propName;
            Matcher matcher;
            if (!(key instanceof String) || !(matcher = DESCRIPTION_KEY_PATTERN.matcher(propName = (String)key)).matches()) continue;
            String optionName = matcher.group(1);
            String description = props.getProperty(propName);
            String defaultValue = props.getProperty(String.format("options.%s.default", optionName));
            String type = props.getProperty(String.format("options.%s.type", optionName));
            Class<?> clazz = null;
            if (type != null) {
                String typeTrimmed = type.trim();
                if (SHORT_CLASSNAMES.containsKey(typeTrimmed)) {
                    clazz = SHORT_CLASSNAMES.get(typeTrimmed);
                } else {
                    try {
                        clazz = Class.forName(typeTrimmed);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException("Can't find class used for type of option '" + optionName + "': " + typeTrimmed);
                    }
                }
            }
            ModuleOption moduleOption = new ModuleOption(optionName, description).withDefaultValue(defaultValue).withType(clazz);
            result.add(moduleOption);
        }
        return result;
    }

    @Override
    public ModuleOptionsMetadata resolve(ModuleDefinition definition) {
        if (!definition.isComposed()) {
            return this.resolveNormalMetadata((SimpleModuleDefinition)definition);
        }
        return this.resolveComposedModuleMetadata((CompositeModuleDefinition)definition);
    }

    private ModuleOptionsMetadata resolveComposedModuleMetadata(CompositeModuleDefinition definition) {
        HashMap<String, ModuleOptionsMetadata> hierarchy = new HashMap<String, ModuleOptionsMetadata>();
        for (ModuleDefinition subModuleDefinition : definition.getChildren()) {
            ModuleOptionsMetadata subMetadata = this.compositeResolver.resolve(subModuleDefinition);
            hierarchy.put(subModuleDefinition.getName(), subMetadata);
        }
        return new HierarchicalCompositeModuleOptionsMetadata(hierarchy);
    }

    private ModuleOptionsMetadata resolveNormalMetadata(SimpleModuleDefinition definition) {
        ClassLoader classLoaderToUse;
        Resource moduleLocation = this.resourceLoader.getResource(definition.getLocation());
        Properties props = ModuleUtils.loadModuleProperties(definition);
        ClassLoader parentCL = ModuleOptionsMetadataResolver.class.getClassLoader();
        ClassLoader classLoader = classLoaderToUse = this.shouldCreateModuleClassLoader ? ModuleUtils.createModuleDiscoveryClassLoader(moduleLocation, parentCL) : parentCL;
        if (props == null) {
            return this.inferModuleOptionsMetadata(definition, classLoaderToUse);
        }
        String pojoClass = props.getProperty(OPTIONS_CLASS);
        if (pojoClass != null) {
            ArrayList<ModuleOptionsMetadata> mixins = new ArrayList<ModuleOptionsMetadata>();
            this.createPojoOptionsMetadata(classLoaderToUse, pojoClass.trim(), mixins);
            return mixins.size() == 1 ? (ModuleOptionsMetadata)mixins.get(0) : new FlattenedCompositeModuleOptionsMetadata(mixins);
        }
        return this.makeSimpleModuleOptions(props);
    }

    private void createPojoOptionsMetadata(ClassLoader classLoaderToUse, String pojoClass, List<ModuleOptionsMetadata> mixins) {
        try {
            Class<?> clazz = Class.forName(pojoClass, true, classLoaderToUse);
            Mixin mixin = clazz.getAnnotation(Mixin.class);
            if (mixin != null) {
                for (Class classToMixin : mixin.value()) {
                    this.createPojoOptionsMetadata(classLoaderToUse, classToMixin.getName(), mixins);
                }
            }
            mixins.add(new PojoModuleOptionsMetadata(clazz, this.conversionService));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to load class used by ModuleOptionsMetadata: " + pojoClass, e);
        }
    }

    private ModuleOptionsMetadata inferModuleOptionsMetadata(SimpleModuleDefinition definition, ClassLoader classLoaderToUse) {
        DefaultListableBeanFactory beanFactory = new DefaultListableBeanFactory();
        Resource source = ModuleUtils.resourceBasedConfigurationFile(definition);
        if (source == null) {
            return new PassthruModuleOptionsMetadata();
        }
        XmlBeanDefinitionReader reader = source.getFilename().endsWith("xml") ? new XmlBeanDefinitionReader((BeanDefinitionRegistry)beanFactory) : new GroovyBeanDefinitionReader((BeanDefinitionRegistry)beanFactory);
        reader.setResourceLoader((ResourceLoader)new PathMatchingResourcePatternResolver(classLoaderToUse));
        reader.loadBeanDefinitions(source);
        return this.defaultModuleOptionsMetadataCollector.collect((ConfigurableListableBeanFactory)beanFactory);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = (ResourcePatternResolver)resourceLoader;
    }

    static {
        SHORT_CLASSNAMES.put("String", String.class);
        SHORT_CLASSNAMES.put("boolean", Boolean.TYPE);
        SHORT_CLASSNAMES.put("Boolean", Boolean.class);
        SHORT_CLASSNAMES.put("int", Integer.TYPE);
        SHORT_CLASSNAMES.put("Integer", Integer.class);
        SHORT_CLASSNAMES.put("long", Long.TYPE);
        SHORT_CLASSNAMES.put("Long", Long.class);
        SHORT_CLASSNAMES.put("float", Float.TYPE);
        SHORT_CLASSNAMES.put("Float", Float.class);
        SHORT_CLASSNAMES.put("double", Double.TYPE);
        SHORT_CLASSNAMES.put("Double", Double.class);
    }
}

