/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.module.options;

import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PlaceholderConfigurerSupport;
import org.springframework.util.PropertyPlaceholderHelper;
import org.springframework.util.StringValueResolver;
import org.springframework.xd.module.options.ModuleOption;
import org.springframework.xd.module.options.ModuleOptionsMetadata;
import org.springframework.xd.module.options.SimpleModuleOptionsMetadata;

public class DefaultModuleOptionsMetadataCollector
extends PlaceholderConfigurerSupport {
    private static final String ALTERNATE_PLACEHOLDER_PREFIX = "*[[";
    private static final String ALTERNATE_PLACEHOLDER_SUFFIX = "]]*";
    private static final String DELIMITERS_RECOVERY_REGEX = "\\Q*[[\\E(.+)\\Q]]*\\E";
    private static final String DELIMITERS_RECOVERY_REPLACEMENT = "\\${$1}";
    final PropertyPlaceholderHelper helper = new PropertyPlaceholderHelper("${", "}");

    protected void processProperties(ConfigurableListableBeanFactory beanFactory, Properties props) throws BeansException {
    }

    public ModuleOptionsMetadata collect(ConfigurableListableBeanFactory beanFactory) {
        final SimpleModuleOptionsMetadata result = new SimpleModuleOptionsMetadata();
        final PropertyPlaceholderHelper.PlaceholderResolver placeholderResolver = new PropertyPlaceholderHelper.PlaceholderResolver(){

            public String resolvePlaceholder(String placeholderName) {
                String optionName;
                int colon = placeholderName.indexOf(58);
                String string = optionName = colon >= 0 ? placeholderName.substring(0, colon) : placeholderName;
                if (optionName.indexOf(46) == -1) {
                    ModuleOption option = new ModuleOption(optionName, "unknown").withType(String.class);
                    if (colon > 0) {
                        String defaultValue = placeholderName.substring(colon + 1);
                        option.withDefaultValue(defaultValue.replaceAll(DefaultModuleOptionsMetadataCollector.DELIMITERS_RECOVERY_REGEX, DefaultModuleOptionsMetadataCollector.DELIMITERS_RECOVERY_REPLACEMENT));
                    }
                    result.add(option);
                }
                return DefaultModuleOptionsMetadataCollector.ALTERNATE_PLACEHOLDER_PREFIX + placeholderName + DefaultModuleOptionsMetadataCollector.ALTERNATE_PLACEHOLDER_SUFFIX;
            }
        };
        StringValueResolver resolver = new StringValueResolver(){

            public String resolveStringValue(String strVal) {
                DefaultModuleOptionsMetadataCollector.this.helper.replacePlaceholders(strVal, placeholderResolver);
                return strVal;
            }
        };
        this.doProcessProperties(beanFactory, resolver);
        return result;
    }
}

