/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.module.core;

import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.xd.module.ModuleDeploymentProperties;
import org.springframework.xd.module.ModuleDescriptor;
import org.springframework.xd.module.ModuleType;
import org.springframework.xd.module.core.Module;

public abstract class AbstractModule
implements Module {
    private final ModuleDescriptor descriptor;
    private final ModuleDeploymentProperties deploymentProperties;

    public AbstractModule(ModuleDescriptor descriptor, ModuleDeploymentProperties deploymentProperties) {
        Assert.notNull((Object)descriptor, (String)"descriptor must not be null");
        Assert.notNull((Object)deploymentProperties, (String)"deploymentProperties must not be null");
        this.descriptor = descriptor;
        this.deploymentProperties = deploymentProperties;
    }

    @Override
    public String getName() {
        return this.descriptor.getModuleName();
    }

    @Override
    public ModuleType getType() {
        return this.descriptor.getType();
    }

    @Override
    public ModuleDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public ModuleDeploymentProperties getDeploymentProperties() {
        return this.deploymentProperties;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [name=" + this.getName() + ", type=" + (Object)((Object)this.getType()) + ", group=" + this.descriptor.getGroup() + ", index=" + this.descriptor.getIndex() + " @" + ObjectUtils.getIdentityHexString((Object)this) + "]";
    }

    @Override
    public boolean shouldBind() {
        return true;
    }
}

