/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.module;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.xd.module.ModuleDefinition;
import org.springframework.xd.module.ModuleType;

public class ModuleDescriptor
implements Comparable<ModuleDescriptor> {
    private final String moduleLabel;
    private final String group;
    private final String sourceChannelName;
    private final String sinkChannelName;
    private final int index;
    private final Map<String, String> parameters;
    private final List<ModuleDescriptor> children;
    private final ModuleDefinition moduleDefinition;

    private ModuleDescriptor(String moduleLabel, String group, String sourceChannelName, String sinkChannelName, int index, ModuleDefinition moduleDefinition, Map<String, String> parameters, List<ModuleDescriptor> children) {
        Assert.notNull((Object)moduleLabel, (String)"moduleLabel must not be null");
        Assert.notNull((Object)group, (String)"group must not be null");
        this.moduleLabel = moduleLabel;
        this.group = group;
        this.sourceChannelName = sourceChannelName;
        this.sinkChannelName = sinkChannelName;
        this.index = index;
        this.moduleDefinition = moduleDefinition;
        this.parameters = parameters == null ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, String>(parameters));
        this.children = children == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<ModuleDescriptor>(children));
    }

    public String getModuleName() {
        return this.moduleDefinition.getName();
    }

    public String getModuleLabel() {
        return this.moduleLabel;
    }

    public String getGroup() {
        return this.group;
    }

    public int getIndex() {
        return this.index;
    }

    public ModuleType getType() {
        return this.moduleDefinition.getType();
    }

    public String getSourceChannelName() {
        return this.sourceChannelName;
    }

    public String getSinkChannelName() {
        return this.sinkChannelName;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public List<ModuleDescriptor> getChildren() {
        return this.children;
    }

    public ModuleDefinition getModuleDefinition() {
        return this.moduleDefinition;
    }

    public boolean isComposed() {
        return !this.children.isEmpty();
    }

    public Key createKey() {
        return new Key(this.getGroup(), this.getType(), this.getModuleLabel());
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("moduleName", this.moduleDefinition != null ? this.moduleDefinition.getName() : null).append("moduleLabel", (Object)this.moduleLabel).append("group", (Object)this.group).append("sourceChannelName", (Object)this.sourceChannelName).append("sinkChannelName", (Object)this.sinkChannelName).append("index", this.index).append("type", this.moduleDefinition != null ? this.moduleDefinition.getType() : null).append("parameters", this.parameters).append("children", this.children).toString();
    }

    @Override
    public int compareTo(ModuleDescriptor o) {
        Assert.notNull((Object)o, (String)"ModuleDescriptor must not be null");
        return this.index < o.index ? -1 : (this.index == o.index ? 0 : 1);
    }

    public static class Key
    implements Comparable<Key> {
        private final String group;
        private final ModuleType type;
        private final String label;

        public Key(String group, ModuleType type, String label) {
            Assert.notNull((Object)group, (String)"Group is required");
            Assert.notNull((Object)((Object)type), (String)"Type is required");
            Assert.hasText((String)label, (String)"Label is required");
            this.group = group;
            this.type = type;
            this.label = label;
        }

        public String getGroup() {
            return this.group;
        }

        public ModuleType getType() {
            return this.type;
        }

        public String getLabel() {
            return this.label;
        }

        @Override
        public int compareTo(Key other) {
            int c = this.type.compareTo(other.getType());
            if (c == 0) {
                c = this.label.compareTo(other.getLabel());
            }
            if (c == 0) {
                c = this.group.compareTo(other.getGroup());
            }
            return c;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Key) {
                Key other = (Key)o;
                return this.group.equals(other.getGroup()) && this.type.equals((Object)other.getType()) && this.label.equals(other.getLabel());
            }
            return false;
        }

        public int hashCode() {
            int result = this.group.hashCode();
            result = 31 * result + this.type.hashCode();
            result = 31 * result + this.label.hashCode();
            return result;
        }

        public String toString() {
            return "ModuleDeploymentKey{stream='" + this.group + '\'' + ", type=" + (Object)((Object)this.type) + ", label='" + this.label + '\'' + '}';
        }
    }

    public static class Builder {
        private String moduleName;
        private String moduleLabel;
        private String group;
        private String sourceChannelName;
        private String sinkChannelName;
        private int index;
        private ModuleType type;
        private final Map<String, String> parameters = new HashMap<String, String>();
        private final List<ModuleDescriptor> children = new ArrayList<ModuleDescriptor>();
        private ModuleDefinition moduleDefinition;

        public Builder setModuleName(String moduleName) {
            this.moduleName = moduleName;
            return this;
        }

        public Builder setModuleLabel(String moduleLabel) {
            this.moduleLabel = moduleLabel;
            return this;
        }

        public Builder setGroup(String group) {
            this.group = group;
            return this;
        }

        public Builder setSourceChannelName(String sourceChannelName) {
            this.sourceChannelName = sourceChannelName;
            return this;
        }

        public Builder setSinkChannelName(String sinkChannelName) {
            this.sinkChannelName = sinkChannelName;
            return this;
        }

        public Builder setIndex(int index) {
            this.index = index;
            return this;
        }

        public Builder setType(ModuleType type) {
            this.type = type;
            return this;
        }

        public Builder addChildren(List<ModuleDescriptor> children) {
            this.children.addAll(children);
            return this;
        }

        public Builder setParameter(String name, String value) {
            this.parameters.put(name, value);
            return this;
        }

        public Builder addParameters(Map<String, String> parameters) {
            this.parameters.putAll(parameters);
            return this;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public String getModuleLabel() {
            return this.moduleLabel;
        }

        public String getGroup() {
            return this.group;
        }

        public String getSourceChannelName() {
            return this.sourceChannelName;
        }

        public String getSinkChannelName() {
            return this.sinkChannelName;
        }

        public int getIndex() {
            return this.index;
        }

        public ModuleType getType() {
            return this.type;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }

        public static Builder fromModuleDescriptor(ModuleDescriptor descriptor) {
            Builder builder = new Builder();
            builder.setModuleName(descriptor.getModuleName());
            builder.setModuleLabel(descriptor.getModuleLabel());
            builder.setGroup(descriptor.getGroup());
            builder.setSourceChannelName(descriptor.getSourceChannelName());
            builder.setSinkChannelName(descriptor.getSinkChannelName());
            builder.setIndex(descriptor.getIndex());
            builder.setType(descriptor.getType());
            builder.setModuleDefinition(descriptor.getModuleDefinition());
            builder.addParameters(descriptor.getParameters());
            builder.addChildren(descriptor.getChildren());
            return builder;
        }

        public ModuleDescriptor build() {
            String label = this.moduleLabel != null ? this.moduleLabel : this.getModuleDefinition().getName();
            return new ModuleDescriptor(label, this.group, this.sourceChannelName, this.sinkChannelName, this.index, this.getModuleDefinition(), this.parameters, this.children);
        }

        public Builder setModuleDefinition(ModuleDefinition moduleDefinition) {
            this.moduleDefinition = moduleDefinition;
            return this;
        }

        public ModuleDefinition getModuleDefinition() {
            if (this.moduleDefinition == null) {
                this.moduleDefinition = new ModuleDefinition(this.moduleName, this.type){

                    @Override
                    public boolean isComposed() {
                        return false;
                    }
                };
            }
            return this.moduleDefinition;
        }
    }
}

