/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.integration.bus;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.springframework.integration.support.json.Jackson2JsonObjectMapper;
import org.springframework.messaging.Message;
import org.springframework.xd.dirt.integration.bus.MessageValues;

public class EmbeddedHeadersMessageConverter {
    private final Jackson2JsonObjectMapper objectMapper = new Jackson2JsonObjectMapper();

    public static String decodeExceptionMessage(Message<?> requestMessage) {
        return "Could not convert message: " + DatatypeConverter.printHexBinary((byte[])((byte[])requestMessage.getPayload()));
    }

    public byte[] embedHeaders(MessageValues original, String ... headers) throws Exception {
        byte[][] headerValues = new byte[headers.length][];
        int n = 0;
        int headerCount = 0;
        int headersLength = 0;
        for (String header : headers) {
            Object value;
            Object object = value = original.get(header) == null ? null : original.get(header);
            if (value != null) {
                String json = this.objectMapper.toJson(value);
                headerValues[n] = json.getBytes("UTF-8");
                ++headerCount;
                headersLength += header.length() + headerValues[n++].length;
                continue;
            }
            headerValues[n++] = null;
        }
        byte[] newPayload = new byte[((byte[])original.getPayload()).length + headersLength + headerCount * 5 + 2];
        ByteBuffer byteBuffer = ByteBuffer.wrap(newPayload);
        byteBuffer.put((byte)-1);
        byteBuffer.put((byte)headerCount);
        for (int i = 0; i < headers.length; ++i) {
            if (headerValues[i] == null) continue;
            byteBuffer.put((byte)headers[i].length());
            byteBuffer.put(headers[i].getBytes("UTF-8"));
            byteBuffer.putInt(headerValues[i].length);
            byteBuffer.put(headerValues[i]);
        }
        byteBuffer.put((byte[])original.getPayload());
        return byteBuffer.array();
    }

    public MessageValues extractHeaders(Message<byte[]> message, boolean copyRequestHeaders) throws Exception {
        byte[] bytes = (byte[])message.getPayload();
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        int headerCount = byteBuffer.get() & 0xFF;
        if (headerCount < 255) {
            return this.oldExtractHeaders(byteBuffer, bytes, headerCount, message, copyRequestHeaders);
        }
        headerCount = byteBuffer.get() & 0xFF;
        HashMap<String, Object> headers = new HashMap<String, Object>();
        for (int i = 0; i < headerCount; ++i) {
            int len = byteBuffer.get() & 0xFF;
            String headerName = new String(bytes, byteBuffer.position(), len, "UTF-8");
            byteBuffer.position(byteBuffer.position() + len);
            len = byteBuffer.getInt();
            String headerValue = new String(bytes, byteBuffer.position(), len, "UTF-8");
            Object headerContent = this.objectMapper.fromJson((Object)headerValue, Object.class);
            headers.put(headerName, headerContent);
            byteBuffer.position(byteBuffer.position() + len);
        }
        byte[] newPayload = new byte[byteBuffer.remaining()];
        byteBuffer.get(newPayload);
        return this.buildMessageValues(message, newPayload, headers, copyRequestHeaders);
    }

    private MessageValues oldExtractHeaders(ByteBuffer byteBuffer, byte[] bytes, int headerCount, Message<byte[]> message, boolean copyRequestHeaders) throws UnsupportedEncodingException {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        for (int i = 0; i < headerCount; ++i) {
            int len = byteBuffer.get();
            String headerName = new String(bytes, byteBuffer.position(), len, "UTF-8");
            byteBuffer.position(byteBuffer.position() + len);
            len = byteBuffer.get() & 0xFF;
            String headerValue = new String(bytes, byteBuffer.position(), len, "UTF-8");
            byteBuffer.position(byteBuffer.position() + len);
            if ("sequenceNumber".equals(headerName) || "sequenceSize".equals(headerName)) {
                headers.put(headerName, Integer.parseInt(headerValue));
                continue;
            }
            headers.put(headerName, headerValue);
        }
        byte[] newPayload = new byte[byteBuffer.remaining()];
        byteBuffer.get(newPayload);
        return this.buildMessageValues(message, newPayload, headers, copyRequestHeaders);
    }

    private MessageValues buildMessageValues(Message<byte[]> message, byte[] payload, Map<String, Object> headers, boolean copyRequestHeaders) {
        MessageValues messageValues = new MessageValues(payload, headers);
        if (copyRequestHeaders) {
            messageValues.copyHeadersIfAbsent((Map<String, Object>)message.getHeaders());
        }
        return messageValues;
    }
}

