/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.integration.bus;

import java.util.regex.Pattern;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BusUtils {
    public static final String GROUP_INDEX_DELIMITER = ".";
    public static final String TAP_CHANNEL_PREFIX = "tap:";
    public static final String TOPIC_CHANNEL_PREFIX = "topic:";
    public static final Pattern PUBSUB_NAMED_CHANNEL_PATTERN = Pattern.compile("[^.]+\\.(tap|topic):");

    public static String addGroupToPubSub(String group, String inputChannelName) {
        if (inputChannelName.startsWith(TAP_CHANNEL_PREFIX) || inputChannelName.startsWith(TOPIC_CHANNEL_PREFIX)) {
            inputChannelName = group + GROUP_INDEX_DELIMITER + inputChannelName;
        }
        return inputChannelName;
    }

    public static String removeGroupFromPubSub(String name) {
        if (PUBSUB_NAMED_CHANNEL_PATTERN.matcher(name).find()) {
            return name.substring(name.indexOf(GROUP_INDEX_DELIMITER) + 1);
        }
        return name;
    }

    public static String getGroupFromPubSub(String name) {
        if (PUBSUB_NAMED_CHANNEL_PATTERN.matcher(name).find()) {
            return name.substring(0, name.indexOf(GROUP_INDEX_DELIMITER));
        }
        return name;
    }

    public static boolean isChannelPubSub(String channelName) {
        Assert.isTrue((boolean)StringUtils.hasText((String)channelName), (String)"Channel name should not be empty/null.");
        return channelName.startsWith(TAP_CHANNEL_PREFIX) || channelName.startsWith(TOPIC_CHANNEL_PREFIX);
    }

    public static String constructPipeName(String group, int index) {
        return group + GROUP_INDEX_DELIMITER + index;
    }

    public static String constructTapPrefix(String group) {
        return "tap:stream:" + group;
    }
}

