/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.integration.bus;

import org.springframework.context.Lifecycle;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;
import org.springframework.xd.dirt.integration.bus.AbstractBusPropertiesAccessor;

public class Binding
implements Lifecycle {
    public static final String PRODUCER = "producer";
    public static final String CONSUMER = "consumer";
    public static final String DIRECT = "direct";
    private final String name;
    private final MessageChannel channel;
    private final AbstractEndpoint endpoint;
    private final String type;
    private final AbstractBusPropertiesAccessor properties;

    private Binding(String name, MessageChannel channel, AbstractEndpoint endpoint, String type, AbstractBusPropertiesAccessor properties) {
        Assert.notNull((Object)channel, (String)"channel must not be null");
        Assert.notNull((Object)endpoint, (String)"endpoint must not be null");
        this.name = name;
        this.channel = channel;
        this.endpoint = endpoint;
        this.type = type;
        this.properties = properties;
    }

    public static Binding forConsumer(String name, AbstractEndpoint adapterFromBus, MessageChannel moduleInputChannel, AbstractBusPropertiesAccessor properties) {
        return new Binding(name, moduleInputChannel, adapterFromBus, CONSUMER, properties);
    }

    public static Binding forProducer(String name, MessageChannel moduleOutputChannel, AbstractEndpoint adapterToBus, AbstractBusPropertiesAccessor properties) {
        return new Binding(name, moduleOutputChannel, adapterToBus, PRODUCER, properties);
    }

    public static Binding forDirectProducer(String name, MessageChannel moduleOutputChannel, AbstractEndpoint adapter, AbstractBusPropertiesAccessor properties) {
        return new Binding(name, moduleOutputChannel, adapter, DIRECT, properties);
    }

    public String getName() {
        return this.name;
    }

    public MessageChannel getChannel() {
        return this.channel;
    }

    public AbstractEndpoint getEndpoint() {
        return this.endpoint;
    }

    public String getType() {
        return this.type;
    }

    public AbstractBusPropertiesAccessor getPropertiesAccessor() {
        return this.properties;
    }

    public void start() {
        this.endpoint.start();
    }

    public void stop() {
        this.endpoint.stop();
    }

    public boolean isRunning() {
        return this.endpoint.isRunning();
    }

    public String toString() {
        return this.type + " Binding [name=" + this.name + ", channel=" + this.channel + ", endpoint=" + this.endpoint.getComponentName() + "]";
    }
}

