/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.transform;

import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;

public class TransformerFactoryUtils {
    public static TransformerFactory newInstance() {
        return TransformerFactoryUtils.defaultSettings(TransformerFactory.newInstance());
    }

    public static TransformerFactory newInstance(Class<? extends TransformerFactory> transformerFactoryClass) {
        try {
            return TransformerFactoryUtils.defaultSettings(transformerFactoryClass.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new TransformerFactoryConfigurationError(e, "Could not instantiate TransformerFactory [" + transformerFactoryClass + "]");
        }
    }

    private static TransformerFactory defaultSettings(TransformerFactory factory) {
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        return factory;
    }
}

