/*
 * Copyright 2005-2010 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.ws.server.endpoint.adapter.method;

import org.springframework.core.MethodParameter;
import org.springframework.ws.context.MessageContext;

/**
 * Implementation of {@link MethodArgumentResolver} that supports {@link MessageContext} arguments.
 *
 * @author Arjen Poutsma
 * @since 2.0
 */
public class MessageContextMethodArgumentResolver implements MethodArgumentResolver {

    public boolean supportsParameter(MethodParameter parameter) {
        return MessageContext.class.equals(parameter.getParameterType());
    }

    public MessageContext resolveArgument(MessageContext messageContext, MethodParameter parameter) throws Exception {
        return messageContext;
    }
}
