/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.test.support;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.jspecify.annotations.Nullable;
import org.springframework.xml.transform.StringResult;
import org.springframework.xml.transform.TransformerHelper;

public class SourceAssertionError
extends AssertionError {
    private final @Nullable String sourceLabel;
    private final @Nullable Source source;
    private final TransformerHelper transformerHelper = new TransformerHelper();

    public SourceAssertionError(String detailMessage, @Nullable String sourceLabel, @Nullable Source source) {
        super((Object)detailMessage);
        this.sourceLabel = sourceLabel;
        this.source = source;
    }

    public @Nullable Source getSource() {
        return this.source;
    }

    public String getMessage() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.getMessage());
        String sourceString = this.getSourceString();
        if (sourceString != null) {
            String newLine = System.lineSeparator();
            builder.append(newLine);
            String label = this.sourceLabel != null ? this.sourceLabel : "Source";
            builder.append(label);
            builder.append(": ");
            builder.append(sourceString);
        }
        return builder.toString();
    }

    private @Nullable String getSourceString() {
        if (this.source != null) {
            try {
                StringResult result = new StringResult();
                Transformer transformer = this.createNonIndentingTransformer();
                transformer.transform(this.source, (Result)result);
                return result.toString();
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
        }
        return null;
    }

    private Transformer createNonIndentingTransformer() throws TransformerConfigurationException {
        Transformer transformer = this.transformerHelper.createTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "no");
        return transformer;
    }
}

