/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.test.client;

import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.client.core.support.WebServiceGatewaySupport;
import org.springframework.ws.test.client.MockSenderConnection;
import org.springframework.ws.test.client.MockWebServiceMessageSender;
import org.springframework.ws.test.client.RequestMatcher;
import org.springframework.ws.test.client.ResponseActions;
import org.springframework.ws.test.support.MockStrategiesHelper;
import org.springframework.ws.transport.WebServiceMessageSender;

public class MockWebServiceServer {
    private final MockWebServiceMessageSender mockMessageSender;

    private MockWebServiceServer(MockWebServiceMessageSender mockMessageSender) {
        Assert.notNull((Object)mockMessageSender, (String)"'mockMessageSender' must not be null");
        this.mockMessageSender = mockMessageSender;
    }

    public static MockWebServiceServer createServer(WebServiceTemplate webServiceTemplate) {
        Assert.notNull((Object)webServiceTemplate, (String)"'webServiceTemplate' must not be null");
        MockWebServiceMessageSender mockMessageSender = new MockWebServiceMessageSender();
        webServiceTemplate.setMessageSender((WebServiceMessageSender)mockMessageSender);
        return new MockWebServiceServer(mockMessageSender);
    }

    public static MockWebServiceServer createServer(WebServiceGatewaySupport gatewaySupport) {
        Assert.notNull((Object)gatewaySupport, (String)"'gatewaySupport' must not be null");
        return MockWebServiceServer.createServer(gatewaySupport.getWebServiceTemplate());
    }

    public static MockWebServiceServer createServer(ApplicationContext applicationContext) {
        MockStrategiesHelper strategiesHelper = new MockStrategiesHelper(applicationContext);
        WebServiceTemplate webServiceTemplate = strategiesHelper.getStrategy(WebServiceTemplate.class);
        if (webServiceTemplate != null) {
            return MockWebServiceServer.createServer(webServiceTemplate);
        }
        WebServiceGatewaySupport gatewaySupport = strategiesHelper.getStrategy(WebServiceGatewaySupport.class);
        if (gatewaySupport != null) {
            return MockWebServiceServer.createServer(gatewaySupport);
        }
        throw new IllegalArgumentException("Could not find either WebServiceTemplate or WebServiceGatewaySupport in application context");
    }

    public ResponseActions expect(RequestMatcher requestMatcher) {
        MockSenderConnection connection = this.mockMessageSender.expectNewConnection();
        connection.addRequestMatcher(requestMatcher);
        return connection;
    }

    public void verify() {
        this.mockMessageSender.verifyConnections();
    }
}

